/*
 * Decompiled with CFR 0.152.
 */
package io.toolforge.spi.service;

import io.toolforge.spi.model.Account;
import io.toolforge.spi.model.AccountCursor;
import io.toolforge.spi.model.AccountId;
import io.toolforge.spi.model.AccountListOrdering;
import io.toolforge.spi.model.AccountPage;
import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.ApiKey;
import io.toolforge.spi.model.ApiKeyCursor;
import io.toolforge.spi.model.ApiKeyDefinition;
import io.toolforge.spi.model.ApiKeyId;
import io.toolforge.spi.model.ApiKeyPage;
import io.toolforge.spi.model.NewApiKey;
import io.toolforge.spi.model.PrefixQuery;
import io.toolforge.spi.model.Username;
import java.io.InputStream;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/accounts")
public interface AccountsApi {
    @POST
    @Path(value="/{accountReference}/apiKeys")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public NewApiKey createAccountApiKey(@PathParam(value="accountReference") AccountReference var1, @Valid ApiKeyDefinition var2);

    @DELETE
    @Path(value="/{accountReference}/apiKeys/{apiKeyId}")
    @Produces(value={"application/problem+json"})
    public void deleteAccountApiKey(@PathParam(value="accountReference") AccountReference var1, @PathParam(value="apiKeyId") ApiKeyId var2);

    @GET
    @Path(value="/{accountReference}")
    @Produces(value={"application/json", "application/problem+json"})
    public Account getAccount(@PathParam(value="accountReference") AccountReference var1);

    @GET
    @Path(value="/{accountReference}/apiKeys/{apiKeyId}")
    @Produces(value={"application/json", "application/problem+json"})
    public ApiKey getAccountApiKey(@PathParam(value="accountReference") AccountReference var1, @PathParam(value="apiKeyId") ApiKeyId var2);

    @GET
    @Path(value="/by/id/{accountId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Account getAccountById(@PathParam(value="accountId") AccountId var1);

    @GET
    @Path(value="/by/username/{username}")
    @Produces(value={"application/json", "application/problem+json"})
    public Account getAccountByUsername(@PathParam(value="username") Username var1);

    @GET
    @Path(value="/{accountReference}/picture")
    @Produces(value={"image/jpeg", "application/problem+json"})
    public InputStream getAccountPicture(@PathParam(value="accountReference") AccountReference var1);

    @GET
    @Path(value="/{accountReference}/apiKeys")
    @Produces(value={"application/json", "application/problem+json"})
    public ApiKeyPage listAccountApiKeys(@PathParam(value="accountReference") AccountReference var1, @QueryParam(value="limit") @Min(value=0L) @Max(value=10L) @DefaultValue(value="10") @Min(value=0L) @Max(value=10L) Integer var2, @QueryParam(value="cursor") ApiKeyCursor var3);

    @GET
    @Produces(value={"application/json"})
    public AccountPage listAccounts(@QueryParam(value="q") PrefixQuery var1, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var2, @QueryParam(value="cursor") AccountCursor var3, @QueryParam(value="order") AccountListOrdering var4);
}

