/*
 * Decompiled with CFR 0.152.
 */
package io.toolforge.spi.service;

import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.Container;
import io.toolforge.spi.model.ContainerCursor;
import io.toolforge.spi.model.ContainerDefinition;
import io.toolforge.spi.model.ContainerId;
import io.toolforge.spi.model.ContainerInstallation;
import io.toolforge.spi.model.ContainerPage;
import io.toolforge.spi.model.ContainerTransfer;
import io.toolforge.spi.model.ContainerUpdate;
import io.toolforge.spi.model.ContainerVersion;
import io.toolforge.spi.model.ContainerVersionCursor;
import io.toolforge.spi.model.ContainerVersionId;
import io.toolforge.spi.model.ContainerVersionPage;
import io.toolforge.spi.model.ContainerVersionPushLogEntries;
import io.toolforge.spi.model.InstalledContainer;
import io.toolforge.spi.model.KeywordQuery;
import io.toolforge.spi.model.Manifest;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/containers")
public interface ContainersApi {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Container createContainer(@Valid ContainerDefinition var1);

    @POST
    @Path(value="/{containerId}/versions/{containerVersion}/deprecate")
    @Produces(value={"application/json", "application/problem+json"})
    public ContainerVersion deprecateContainerVersion(@PathParam(value="containerId") ContainerId var1, @PathParam(value="containerVersion") ContainerVersionId var2);

    @GET
    @Path(value="/by/owner/{owner}/slug/{slug}")
    @Produces(value={"application/json", "application/problem+json"})
    public Container findContainerByOwnerSlug(@PathParam(value="owner") AccountReference var1, @PathParam(value="slug") String var2);

    @GET
    @Path(value="/{containerId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Container getContainer(@PathParam(value="containerId") ContainerId var1);

    @GET
    @Path(value="/{containerId}/logs/push")
    @Produces(value={"application/json", "application/problem+json"})
    public ContainerVersionPushLogEntries getContainerPushLogs(@PathParam(value="containerId") ContainerId var1);

    @GET
    @Path(value="/{containerId}/versions/{containerVersion}")
    @Produces(value={"application/json", "application/problem+json"})
    public ContainerVersion getContainerVersion(@PathParam(value="containerId") ContainerId var1, @PathParam(value="containerVersion") ContainerVersionId var2);

    @POST
    @Path(value="/{containerId}/install")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public InstalledContainer installContainer(@PathParam(value="containerId") ContainerId var1, @Valid ContainerInstallation var2);

    @GET
    @Path(value="/{containerId}/versions")
    @Produces(value={"application/json", "application/problem+json"})
    public ContainerVersionPage listContainerVersions(@PathParam(value="containerId") ContainerId var1, @QueryParam(value="limit") @DefaultValue(value="10") Integer var2, @QueryParam(value="cursor") ContainerVersionCursor var3);

    @GET
    @Produces(value={"application/json"})
    public ContainerPage listContainers(@QueryParam(value="q") KeywordQuery var1, @QueryParam(value="owner") AccountReference var2, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var3, @QueryParam(value="cursor") ContainerCursor var4);

    @POST
    @Path(value="/{containerId}/versions/{containerVersion}/release")
    @Produces(value={"application/json", "application/problem+json"})
    public ContainerVersion releaseContainerVersion(@PathParam(value="containerId") ContainerId var1, @PathParam(value="containerVersion") ContainerVersionId var2);

    @POST
    @Path(value="/{containerId}/transfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Container transferContainer(@PathParam(value="containerId") ContainerId var1, @Valid ContainerTransfer var2);

    @PATCH
    @Path(value="/{containerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Container updateContainer(@PathParam(value="containerId") ContainerId var1, @Valid ContainerUpdate var2);

    @POST
    @Path(value="/{containerId}/validate/manifest")
    @Consumes(value={"application/yaml"})
    @Produces(value={"application/problem+json"})
    public void validateContainerManifest(@PathParam(value="containerId") ContainerId var1, @Valid Manifest var2);
}

