/*
 * Decompiled with CFR 0.152.
 */
package io.toolforge.spi.service;

import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.Blob;
import io.toolforge.spi.model.BlobId;
import io.toolforge.spi.model.Execution;
import io.toolforge.spi.model.ExecutionCursor;
import io.toolforge.spi.model.ExecutionId;
import io.toolforge.spi.model.ExecutionPage;
import io.toolforge.spi.model.ExecutionState;
import io.toolforge.spi.model.ExecutionTransfer;
import io.toolforge.spi.model.ExecutionUpdate;
import io.toolforge.spi.model.KeywordQuery;
import io.toolforge.spi.model.LogCursor;
import io.toolforge.spi.model.LogPage;
import io.toolforge.spi.model.Secret;
import io.toolforge.spi.model.SecretCursor;
import io.toolforge.spi.model.SecretDefinition;
import io.toolforge.spi.model.SecretId;
import io.toolforge.spi.model.SecretPage;
import io.toolforge.spi.model.SecretTransfer;
import io.toolforge.spi.model.SecretUpdate;
import io.toolforge.spi.model.Tool;
import io.toolforge.spi.model.ToolCursor;
import io.toolforge.spi.model.ToolId;
import io.toolforge.spi.model.ToolInvocation;
import io.toolforge.spi.model.ToolListOrdering;
import io.toolforge.spi.model.ToolPage;
import io.toolforge.spi.model.ToolTransfer;
import io.toolforge.spi.model.ToolUpdate;
import io.toolforge.spi.model.Workspace;
import io.toolforge.spi.model.WorkspaceCursor;
import io.toolforge.spi.model.WorkspaceId;
import io.toolforge.spi.model.WorkspacePage;
import java.io.InputStream;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/workspaces")
public interface WorkspacesApi {
    @POST
    @Path(value="/{workspaceId}/executions/{executionId}/cancel")
    @Produces(value={"application/json", "application/problem+json"})
    public Execution cancelExecution(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2);

    @POST
    @Path(value="/{workspaceId}/blobs")
    @Produces(value={"application/json"})
    public Blob createBlob(@PathParam(value="workspaceId") WorkspaceId var1, @Valid InputStream var2);

    @POST
    @Path(value="/{workspaceId}/secrets")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Secret createWorkspaceSecret(@PathParam(value="workspaceId") WorkspaceId var1, @Valid SecretDefinition var2);

    @DELETE
    @Path(value="/{workspaceId}/executions/{executionId}")
    @Produces(value={"application/problem+json"})
    public void deleteExecution(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2);

    @DELETE
    @Path(value="/{workspaceId}/secrets/{secretId}")
    @Produces(value={"application/problem+json"})
    public void deleteWorkspaceSecret(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="secretId") SecretId var2);

    @POST
    @Path(value="/{workspaceId}/tools/{toolId}/execute")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Execution executeWorkspaceTool(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="toolId") ToolId var2, @Valid ToolInvocation var3);

    @GET
    @Path(value="/{workspaceId}/secrets/by/name/{name}")
    @Produces(value={"application/json", "application/problem+json"})
    public Secret findWorkspaceSecretByName(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="name") String var2);

    @GET
    @Path(value="/{workspaceId}/blobs/{blobId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Blob getBlob(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="blobId") BlobId var2);

    @GET
    @Path(value="/{workspaceId}/executions/{executionId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Execution getExecution(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2);

    @GET
    @Path(value="/{workspaceId}/executions/{executionId}/inputs/{name}")
    @Produces(value={"*/*", "application/problem+json"})
    public InputStream getExecutionInputData(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @PathParam(value="name") String var3);

    @GET
    @Path(value="/{workspaceId}/executions/{executionId}/outputs/{name}")
    @Produces(value={"*/*", "application/json", "application/problem+json"})
    public InputStream getExecutionOutputData(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @PathParam(value="name") String var3);

    @GET
    @Path(value="/{workspaceId}/executions/{executionId}/outputs/{name}.{extension}")
    @Produces(value={"*/*", "application/json", "application/problem+json"})
    public InputStream getExecutionOutputExtensionData(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @PathParam(value="name") String var3, @PathParam(value="extension") String var4);

    @GET
    @Path(value="/{workspaceId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Workspace getWorkspace(@PathParam(value="workspaceId") WorkspaceId var1);

    @GET
    @Path(value="/{workspaceId}/secrets/{secretId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Secret getWorkspaceSecret(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="secretId") SecretId var2);

    @GET
    @Path(value="/{workspaceId}/tools/{toolId}")
    @Produces(value={"application/json", "application/problem+json"})
    public Tool getWorkspaceTool(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="toolId") ToolId var2);

    @GET
    @Path(value="/{workspaceId}/executions/{executionId}/logs")
    @Produces(value={"application/json", "application/problem+json"})
    public LogPage listExecutionLogs(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @QueryParam(value="limit") @DefaultValue(value="10") Integer var3, @QueryParam(value="cursor") LogCursor var4);

    @GET
    @Path(value="/{workspaceId}/executions")
    @Produces(value={"application/json"})
    public ExecutionPage listExecutions(@PathParam(value="workspaceId") WorkspaceId var1, @QueryParam(value="q") KeywordQuery var2, @QueryParam(value="owner") AccountReference var3, @QueryParam(value="state") ExecutionState var4, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var5, @QueryParam(value="cursor") ExecutionCursor var6);

    @GET
    @Path(value="/{workspaceId}/secrets")
    @Produces(value={"application/json"})
    public SecretPage listWorkspaceSecrets(@PathParam(value="workspaceId") WorkspaceId var1, @QueryParam(value="q") KeywordQuery var2, @QueryParam(value="owner") AccountReference var3, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var4, @QueryParam(value="cursor") SecretCursor var5);

    @GET
    @Path(value="/{workspaceId}/tools")
    @Produces(value={"application/json", "application/problem+json"})
    public ToolPage listWorkspaceTools(@PathParam(value="workspaceId") WorkspaceId var1, @QueryParam(value="q") KeywordQuery var2, @QueryParam(value="owner") AccountReference var3, @QueryParam(value="order") ToolListOrdering var4, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var5, @QueryParam(value="cursor") ToolCursor var6);

    @GET
    @Produces(value={"application/json"})
    public WorkspacePage listWorkspaces(@QueryParam(value="q") KeywordQuery var1, @QueryParam(value="owner") AccountReference var2, @QueryParam(value="limit") @Min(value=0L) @Max(value=100L) @DefaultValue(value="10") @Min(value=0L) @Max(value=100L) Integer var3, @QueryParam(value="cursor") WorkspaceCursor var4);

    @POST
    @Path(value="/{workspaceId}/executions/{executionId}/transfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Execution transferExecution(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @Valid ExecutionTransfer var3);

    @POST
    @Path(value="/{workspaceId}/secrets/{secretId}/transfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Secret transferWorkspaceSecret(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="secretId") SecretId var2, @Valid SecretTransfer var3);

    @POST
    @Path(value="/{workspaceId}/tools/{toolId}/transfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Tool transferWorkspaceTool(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="toolId") ToolId var2, @Valid ToolTransfer var3);

    @PATCH
    @Path(value="/{workspaceId}/executions/{executionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Execution updateExecution(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="executionId") ExecutionId var2, @Valid ExecutionUpdate var3);

    @PATCH
    @Path(value="/{workspaceId}/secrets/{secretId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Secret updateWorkspaceSecret(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="secretId") SecretId var2, @Valid SecretUpdate var3);

    @PATCH
    @Path(value="/{workspaceId}/tools/{toolId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public Tool updateWorkspaceTool(@PathParam(value="workspaceId") WorkspaceId var1, @PathParam(value="toolId") ToolId var2, @Valid ToolUpdate var3);
}

