/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.templateblocks;

import io.toolisticon.aptk.templating.ModelPathResolver;
import io.toolisticon.aptk.templating.ParseUtilities;
import io.toolisticon.aptk.templating.exceptions.InvalidExpressionResult;
import io.toolisticon.aptk.templating.exceptions.InvalidPathException;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockBinder;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForTemplateBlock
implements TemplateBlock {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s*(\\w+?)\\s*[:]\\s*((?:\\w|[.])+?)\\s*");
    private final String loopVariableName;
    private final String accessPath;
    private final String templateString;
    private TemplateBlockBinder binder;

    public ForTemplateBlock(String attributeString, String templateString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("for command has no attribute string.");
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(attributeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("for command has an invalid attribute string.");
        }
        this.loopVariableName = matcher.group(1);
        this.accessPath = matcher.group(2);
        this.templateString = ParseUtilities.trimContentString(templateString);
        this.binder = new TemplateBlockBinder(templateString);
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.FOR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getContent(Map<String, Object> outerVariables) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(outerVariables);
        Object values = ModelPathResolver.resolveModelPath(outerVariables, this.accessPath).getValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (values == null) throw new InvalidExpressionResult("For template accessPath '" + this.accessPath + "' must not evaluate to null value!");
        if (values.getClass().isArray()) {
            for (Object value : (Object[])values) {
                variables.put(this.loopVariableName, value);
                stringBuilder.append(this.binder.getContent(variables));
            }
            return stringBuilder.toString();
        } else {
            if (!(values instanceof Collection)) throw new InvalidPathException("Unable to iterate over Type '" + values.getClass().getCanonicalName() + "' in FOR block. Just Arrays and Collections are supported !");
            for (Object value : (Collection)values) {
                variables.put(this.loopVariableName, value);
                stringBuilder.append(this.binder.getContent(variables));
            }
        }
        return stringBuilder.toString();
    }

    public TemplateBlockBinder getBinder() {
        return this.binder;
    }

    public void setBinder(TemplateBlockBinder binder) {
        this.binder = binder;
    }

    public String getLoopVariableName() {
        return this.loopVariableName;
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getTemplateString() {
        return this.templateString;
    }
}

