/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating;

import io.toolisticon.aptk.templating.NextDetectedBlockResult;
import io.toolisticon.aptk.templating.exceptions.InvalidIncludeModelExpression;
import io.toolisticon.aptk.templating.expressions.ExpressionParser;
import io.toolisticon.aptk.templating.templateblocks.ForTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.IfTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.IncludeTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.PlainTextTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.StaticTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockBinder;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockType;
import io.toolisticon.aptk.templating.templateblocks.VariableTextTemplateBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseUtilities {
    public static final Pattern DYNAMIC_TEXT_BLOCK_REGEX = Pattern.compile("[$][{]\\s*((?:\\w|.)*?)\\s*[}]");

    public static TemplateBlockBinder parseString(String templateString) {
        String tmpTemplateString = templateString;
        TemplateBlockBinder binder = new TemplateBlockBinder(tmpTemplateString);
        NextDetectedBlockResult nextBlock = TemplateBlockType.getNextBlock(templateString);
        while (nextBlock != null) {
            if (nextBlock.getBeginIndex() != 0) {
                binder.addTemplateBlock(new PlainTextTemplateBlock(tmpTemplateString.substring(0, nextBlock.getBeginIndex())));
            }
            switch (nextBlock.getTemplateBlockType()) {
                case DYNAMIC_TEXT: {
                    ParserResult nextDynamicText = ParseUtilities.getNextDynamicText(tmpTemplateString);
                    binder.addTemplateBlock(new VariableTextTemplateBlock(nextDynamicText.getContent()));
                    tmpTemplateString = tmpTemplateString.substring(nextDynamicText.getEndIndex());
                    break;
                }
                case FOR: {
                    ForTemplateBlock forTemplateBlock = new ForTemplateBlock(nextBlock.getAttributes(), nextBlock.getContent());
                    binder.addTemplateBlock(forTemplateBlock);
                    forTemplateBlock.setBinder(ParseUtilities.parseString(forTemplateBlock.getTemplateString()));
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
                case IF: {
                    IfTemplateBlock ifTemplateBlock = new IfTemplateBlock(nextBlock.getAttributes(), nextBlock.getContent());
                    binder.addTemplateBlock(ifTemplateBlock);
                    ifTemplateBlock.setBinder(ParseUtilities.parseString(ifTemplateBlock.getTemplateString()));
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
                case INCLUDE: {
                    IncludeTemplateBlock includeTemplateBlock = new IncludeTemplateBlock(nextBlock.getAttributes(), nextBlock.getContent());
                    binder.addTemplateBlock(includeTemplateBlock);
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
                case STATIC: {
                    StaticTemplateBlock staticTemplateBlock = new StaticTemplateBlock(nextBlock.getContent());
                    binder.addTemplateBlock(staticTemplateBlock);
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
            }
            nextBlock = TemplateBlockType.getNextBlock(tmpTemplateString);
        }
        binder.addTemplateBlock(new PlainTextTemplateBlock(tmpTemplateString));
        return binder;
    }

    protected static ParserResult getNextDynamicText(String templateString) {
        if (templateString == null) {
            return null;
        }
        Matcher matcher = DYNAMIC_TEXT_BLOCK_REGEX.matcher(templateString);
        if (matcher.find()) {
            return new ParserResult(matcher.start(), matcher.end(), matcher.group(1));
        }
        return null;
    }

    public static String readResourceToString(String resourcefileName) throws IOException {
        InputStream inputStream = ParseUtilities.class.getResourceAsStream(resourcefileName);
        if (inputStream != null) {
            return ParseUtilities.readFromInputStream(inputStream);
        }
        throw new IllegalArgumentException("Can't open resource file '" + resourcefileName + "'");
    }

    public static String readFromInputStream(InputStream stream) throws IOException {
        byte[] buffer = new byte[10000];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int line = 0;
        while ((line = stream.read(buffer)) != -1) {
            os.write(buffer, 0, line);
        }
        stream.close();
        os.flush();
        os.close();
        return new String(os.toByteArray());
    }

    public static String trimContentString(String content) {
        String tmpContentString = content;
        tmpContentString = tmpContentString.replaceFirst("^[ ]*?\n", "");
        tmpContentString = tmpContentString.replaceAll("[ ]+$", "");
        return tmpContentString;
    }

    public static Map<String, String> parseNamedAttributes(String attributeString) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        String attributePatternString = "\\s*(\\w+)\\s*:\\s*'(.*?)'\\s*";
        Pattern attributePattern = Pattern.compile("(\\s*(\\w+)\\s*:\\s*'(.*?)'\\s*)(?:,(\" + attributePatternString+ \"))*");
        Matcher matcher = attributePattern.matcher(attributeString);
        if (matcher.matches()) {
            Pattern findPattern = Pattern.compile("\\s*(\\w+)\\s*:\\s*'(.*?)'\\s*");
            Matcher findMatcher = findPattern.matcher(attributeString);
            while (findMatcher.find()) {
                String attributeName = findMatcher.group(1);
                String attributeValue = findMatcher.group(2);
                attributeMap.put(attributeName, attributeValue);
            }
        }
        return attributeMap;
    }

    public static Map<String, Object> extractModelFromString(Map<String, Object> outerModel, String modelString) {
        String[] modelStringLines;
        if (outerModel == null) {
            throw new IllegalArgumentException("passed outerModel must not be null");
        }
        if (modelString == null) {
            throw new IllegalArgumentException("passed modelString must not be null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String line : modelStringLines = modelString.split("\\r{0,1}\\n")) {
            Pattern keyValueExtractionPattern = Pattern.compile("^\\s*(\\w+(?:[.]\\w+)*)\\s*[:]\\s*(.+)\\s*$");
            if (line.trim().isEmpty() || line.trim().startsWith("//")) continue;
            Matcher matcher = keyValueExtractionPattern.matcher(line);
            if (matcher.matches()) {
                try {
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    ParseUtilities.addKeyValuePair(outerModel, result, key, value);
                    continue;
                }
                catch (Exception e) {
                    throw new InvalidIncludeModelExpression("couldn't add get key/value pair for expression : " + line, e);
                }
            }
            throw new InvalidIncludeModelExpression("key/value pair expression for generating a model isn't syntactically correct ( '<TARGET MODEL ACCESS PATH SEPARATED BY .>:<VALUE EXPRESSION>'): " + line);
        }
        return result;
    }

    static void addKeyValuePair(Map<String, Object> outerModel, Map<String, Object> modelToBuild, String key, String valueExpression) {
        String[] keyAccessPath = key.split("[.]");
        String valueKey = keyAccessPath[keyAccessPath.length - 1];
        HashMap targetMap = modelToBuild;
        for (int i = 0; i < keyAccessPath.length - 1; ++i) {
            Object accessChainObject = targetMap.get(keyAccessPath[i]);
            if (accessChainObject == null) {
                HashMap nextMap = new HashMap();
                targetMap.put(keyAccessPath[i], nextMap);
                targetMap = nextMap;
                continue;
            }
            if (Map.class.isAssignableFrom(accessChainObject.getClass())) {
                targetMap = (HashMap)accessChainObject;
                continue;
            }
            throw new IllegalArgumentException("key path must not include Objects others than of type Map");
        }
        targetMap.put(valueKey, ExpressionParser.parseExpression(valueExpression, outerModel).evaluateExpression().value());
    }

    private static enum NextBlockType {
        NONE,
        FOR,
        IF,
        STATIC,
        DYNAMIC_TEXT;

    }

    public static class ParserResult {
        private final int beginIndex;
        private final int endIndex;
        private final String content;

        public ParserResult(int beginIndex, int endIndex, String content) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.content = content;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getContent() {
            return this.content;
        }
    }
}

