/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.expressions.operations;

import io.toolisticon.aptk.templating.expressions.operands.InternalOperandTypeForCalculations;
import io.toolisticon.aptk.templating.expressions.operands.Operand;
import io.toolisticon.aptk.templating.expressions.operands.OperandFactory;
import io.toolisticon.aptk.templating.expressions.operations.OperationTypeMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public enum OperationType {
    NEGATE("[ ]*[!]", 0, OperationTypeMode.UNARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.BOOLEAN}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand = operands[0];
            return OperandFactory.createOperationResult(Boolean.class, (Boolean)operand.value() == false);
        }
    }
    ,
    AND("[&]{2}", 80, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.BOOLEAN}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            return OperandFactory.createOperationResult(Boolean.class, (Boolean)operand1.value() != false && (Boolean)operand2.value() != false);
        }
    }
    ,
    OR("[|]{2}", 85, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.BOOLEAN}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            return OperandFactory.createOperationResult(Boolean.class, (Boolean)operand1.value() != false || (Boolean)operand2.value() != false);
        }
    }
    ,
    EQUAL("[=]{2}", 70, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[0]){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, false, false);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            boolean result = false;
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) && InternalOperandTypeForCalculations.DECIMAL.equals((Object)internalOperandTypeForCalculations2) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2) && InternalOperandTypeForCalculations.DECIMAL.equals((Object)internalOperandTypeForCalculations1)) {
                operand1 = OperandFactory.createOperationResult(Double.class, this.convertToDouble(operand1));
                operand2 = OperandFactory.createOperationResult(Double.class, this.convertToDouble(operand2));
                internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
                internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            }
            if (operand1.getOperandsJavaType() != null && operand2.getOperandsJavaType() != null && !operand1.getOperandsJavaType().equals(operand2.getOperandsJavaType()) && !internalOperandTypeForCalculations1.equals((Object)internalOperandTypeForCalculations2)) {
                throw new IllegalArgumentException("Incompatible operand types in '==' operation");
            }
            if (operand1.value() == null && operand2.value() == null) {
                result = true;
            } else if (operand1.value() == null && operand2.value() != null || operand1.value() != null && operand2.value() == null) {
                result = false;
            } else if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) && InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                result = operand1Value.equals(operand2Value);
            } else if (InternalOperandTypeForCalculations.DECIMAL.equals((Object)internalOperandTypeForCalculations1) && InternalOperandTypeForCalculations.DECIMAL.equals((Object)internalOperandTypeForCalculations2)) {
                Long operand1Value = this.convertToLong(operand1);
                Long operand2Value = this.convertToLong(operand2);
                result = operand1Value.equals(operand2Value);
            } else {
                result = operand1.value().equals(operand2.value());
            }
            return OperandFactory.createOperationResult(Boolean.class, result);
        }
    }
    ,
    NOT_EQUAL("[!][=]", 70, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[0]){

        @Override
        public Operand doOperation(Operand ... operands) {
            return NEGATE.doOperation(EQUAL.doOperation(operands));
        }
    }
    ,
    LESS_OR_EQUAL_THAN("[<][=]", 60, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Boolean.class, operand1Value <= operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Boolean.class, operand1Value <= operand2Value);
        }
    }
    ,
    GREATER_OR_EQUAL_THAN("[>][=]", 60, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Boolean.class, operand1Value >= operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Boolean.class, operand1Value >= operand2Value);
        }
    }
    ,
    LESS_THAN("[<]", 60, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Boolean.class, operand1Value < operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Boolean.class, operand1Value < operand2Value);
        }
    }
    ,
    GREATER_THAN("[>]", 60, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Boolean.class, operand1Value > operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Boolean.class, operand1Value > operand2Value);
        }
    }
    ,
    ADDITION("[+]", 50, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.STRING, InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.STRING.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.STRING.equals((Object)internalOperandTypeForCalculations2)) {
                String operand1Value = this.convertToString(operand1);
                String operand2Value = this.convertToString(operand2);
                return OperandFactory.createOperationResult(String.class, operand1Value + operand2Value);
            }
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Double.class, operand1Value + operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Long.class, operand1Value + operand2Value);
        }
    }
    ,
    SUBTRACTION("[-]", 50, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Double.class, operand1Value - operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Long.class, operand1Value - operand2Value);
        }
    }
    ,
    MULTIPLICATION("[*]", 40, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Double.class, operand1Value * operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Long.class, operand1Value * operand2Value);
        }
    }
    ,
    DIVISION("[/]", 40, OperationTypeMode.BINARY, new InternalOperandTypeForCalculations[]{InternalOperandTypeForCalculations.DECIMAL, InternalOperandTypeForCalculations.FLOAT}){

        @Override
        public Operand doOperation(Operand ... operands) {
            this.doBaseChecks(this, operands, true, true);
            Operand operand1 = operands[0];
            Operand operand2 = operands[1];
            InternalOperandTypeForCalculations internalOperandTypeForCalculations1 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand1);
            InternalOperandTypeForCalculations internalOperandTypeForCalculations2 = InternalOperandTypeForCalculations.getOperationModeForOperand(operand2);
            if (InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations1) || InternalOperandTypeForCalculations.FLOAT.equals((Object)internalOperandTypeForCalculations2)) {
                Double operand1Value = this.convertToDouble(operand1);
                Double operand2Value = this.convertToDouble(operand2);
                return OperandFactory.createOperationResult(Double.class, operand1Value / operand2Value);
            }
            Long operand1Value = this.convertToLong(operand1);
            Long operand2Value = this.convertToLong(operand2);
            return OperandFactory.createOperationResult(Long.class, operand1Value / operand2Value);
        }
    };

    private final Pattern operationPattern;
    private final int operationExecutionOrder;
    private final OperationTypeMode operationTypeMode;
    private final Set<Class> supportedTypes = new HashSet<Class>();

    private OperationType(String operationPatternString, int operationOrder, OperationTypeMode operationTypeMode, InternalOperandTypeForCalculations ... supportedInternalOperandTypeForCalculationses) {
        this.operationPattern = Pattern.compile("[ ]*" + operationPatternString + "[ ]*");
        this.operationExecutionOrder = operationOrder;
        this.operationTypeMode = operationTypeMode;
        this.supportedTypes.addAll(InternalOperandTypeForCalculations.getSupportedOperandModeClasses(supportedInternalOperandTypeForCalculationses));
    }

    public OperationTypeMode getOperationTypeMode() {
        return this.operationTypeMode;
    }

    public Pattern getOperationPattern() {
        return this.operationPattern;
    }

    public int getOperationExecutionOrder() {
        return this.operationExecutionOrder;
    }

    public static OperationType[] getOperationsByOperationTypeMode(OperationTypeMode operationTypeMode) {
        ArrayList<OperationType> result = new ArrayList<OperationType>();
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.getOperationTypeMode().equals((Object)operationTypeMode)) continue;
            result.add(operationType);
        }
        Collections.sort(result, new Comparator<OperationType>(){

            @Override
            public int compare(OperationType o1, OperationType o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1.getOperationExecutionOrder() == o2.getOperationExecutionOrder()) {
                    return 0;
                }
                if (o1.getOperationExecutionOrder() < o2.getOperationExecutionOrder()) {
                    return -1;
                }
                return 1;
            }
        });
        return result.toArray(new OperationType[result.size()]);
    }

    public abstract Operand doOperation(Operand ... var1);

    protected void doBaseChecks(OperationType operationType, Operand[] operands, boolean doNullCheck, boolean doSupportedTypesCheck) {
        int i;
        if (operationType == null) {
            throw new IllegalArgumentException("passed operationType must not be null");
        }
        if (operationType.getOperationTypeMode().getNumberOfOperands() != operands.length) {
            throw new IllegalArgumentException("Got invalid number of operands for operation type " + operationType.name() + " - needed " + operationType.getOperationTypeMode().getNumberOfOperands() + " operands, but got " + operands.length);
        }
        for (i = 0; i < operationType.getOperationTypeMode().getNumberOfOperands(); ++i) {
            if (operands[i] != null) continue;
            throw new IllegalArgumentException("passed operands must not be null");
        }
        if (doNullCheck) {
            for (i = 0; i < operationType.getOperationTypeMode().getNumberOfOperands(); ++i) {
                if (operands[i].value() != null) continue;
                throw new IllegalArgumentException("passed operand values must not be null");
            }
        }
        if (doSupportedTypesCheck) {
            for (i = 0; i < operationType.getOperationTypeMode().getNumberOfOperands(); ++i) {
                if (this.supportedTypes.contains(operands[i].getOperandsJavaType())) continue;
                throw new IllegalArgumentException("At least one operand type (" + Operand.getStringRepresentationOfOperandsJavaTypes(operands) + ") isn't supported by the operation " + operationType.name());
            }
        }
    }

    protected String convertToString(Operand operand) {
        if (operand == null || operand.value() == null) {
            return null;
        }
        return operand.value().toString();
    }

    protected Double convertToDouble(Operand operand) {
        if (operand == null || operand.getOperandsJavaType() == null) {
            return null;
        }
        if (Float.class.equals(operand.getOperandsJavaType()) || Float.TYPE.equals(operand.getOperandsJavaType())) {
            return ((Float)operand.value()).doubleValue();
        }
        if (Double.class.equals(operand.getOperandsJavaType()) || Double.TYPE.equals(operand.getOperandsJavaType())) {
            return (Double)operand.value();
        }
        Long longValue = this.convertToLong(operand);
        if (longValue != null) {
            return longValue.doubleValue();
        }
        return null;
    }

    protected Long convertToLong(Operand operand) {
        if (operand == null || operand.getOperandsJavaType() == null) {
            return null;
        }
        if (Short.class.equals(operand.getOperandsJavaType()) || Short.TYPE.equals(operand.getOperandsJavaType())) {
            return ((Short)operand.value()).longValue();
        }
        if (Integer.class.equals(operand.getOperandsJavaType()) || Integer.TYPE.equals(operand.getOperandsJavaType())) {
            return ((Integer)operand.value()).longValue();
        }
        if (Long.class.equals(operand.getOperandsJavaType()) || Long.TYPE.equals(operand.getOperandsJavaType())) {
            return (Long)operand.value();
        }
        return null;
    }
}

