/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.expressions;

import io.toolisticon.aptk.templating.expressions.operands.ExpressionOperand;
import io.toolisticon.aptk.templating.expressions.operands.Operand;
import io.toolisticon.aptk.templating.expressions.operands.OperandType;
import io.toolisticon.aptk.templating.expressions.operations.OperationType;
import io.toolisticon.aptk.templating.expressions.operations.OperationTypeMode;
import java.util.ArrayList;
import java.util.Arrays;

public class Expression {
    private Operand[] operands;
    private OperationType[] operationTypes;

    public Expression(Operand[] operands, OperationType[] operationTypes) {
        this.operands = operands;
        this.operationTypes = operationTypes;
    }

    public Operand[] getOperands() {
        return this.operands;
    }

    public OperationType[] getOperationTypes() {
        return this.operationTypes;
    }

    public Operand evaluateExpression() {
        if (this.operands.length == 1 && this.operationTypes.length == 0) {
            return this.operands[0];
        }
        for (int i = 0; i < this.operands.length; ++i) {
            if (!this.operands[i].getOperandType().equals((Object)OperandType.EXPRESSION)) continue;
            this.operands[i] = ((ExpressionOperand)this.operands[i]).getExpression().evaluateExpression();
        }
        for (OperationType binaryOperationType : OperationType.getOperationsByOperationTypeMode(OperationTypeMode.BINARY)) {
            boolean foundOperation = true;
            block2: while (foundOperation) {
                foundOperation = false;
                for (int operationIndex = 0; operationIndex < this.operationTypes.length; ++operationIndex) {
                    if (!binaryOperationType.equals((Object)this.operationTypes[operationIndex])) continue;
                    this.applyOperation(operationIndex);
                    foundOperation = true;
                    continue block2;
                }
            }
        }
        return this.operands[0];
    }

    private void applyOperation(int operationIndex) {
        if (operationIndex >= 0 && operationIndex < this.operationTypes.length) {
            ArrayList<Operand> newOperands = new ArrayList<Operand>(Arrays.asList(this.operands));
            ArrayList<OperationType> newOperationTypes = new ArrayList<OperationType>(Arrays.asList(this.operationTypes));
            Operand operand1 = (Operand)newOperands.get(operationIndex);
            Operand operand2 = (Operand)newOperands.get(operationIndex + 1);
            OperationType operationtype = (OperationType)((Object)newOperationTypes.get(operationIndex));
            newOperands.remove(operationIndex + 1);
            newOperands.set(operationIndex, operationtype.doOperation(operand1, operand2));
            newOperationTypes.remove(operationIndex);
            this.operands = newOperands.toArray(new Operand[newOperands.size()]);
            this.operationTypes = newOperationTypes.toArray(new OperationType[newOperationTypes.size()]);
        }
    }
}

