/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.expressions.operands;

import io.toolisticon.aptk.templating.expressions.operands.OperandType;
import io.toolisticon.aptk.templating.expressions.operands.ParsedOperand;
import java.util.regex.Matcher;

public class StringOperand
extends ParsedOperand<String> {
    private final String internalValue;

    public StringOperand(String expressionString) {
        super(expressionString);
        Matcher matcher = this.getOperandType().getOperandPattern().matcher(expressionString);
        if (matcher.find()) {
            String tempValue = matcher.group(1);
            tempValue = tempValue.replaceAll("\\\\[']", "'");
            this.internalValue = tempValue = tempValue.replaceAll("\\\\", "\\");
        } else {
            this.internalValue = null;
        }
    }

    @Override
    public Class<String> getOperandsJavaType() {
        return String.class;
    }

    @Override
    public String value() {
        return this.internalValue;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.STRING;
    }
}

