/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.expressions.operands;

import io.toolisticon.aptk.templating.expressions.operands.Operand;
import io.toolisticon.aptk.templating.expressions.operands.OperandType;
import io.toolisticon.aptk.templating.expressions.operations.OperationType;
import io.toolisticon.aptk.templating.expressions.operations.OperationTypeMode;

public class UnaryOperationWrapperOperand
extends Operand<Object> {
    private final Operand operand;
    private final OperationType unaryOperationType;
    private Operand resultOperand = null;

    public UnaryOperationWrapperOperand(Operand operand, OperationType unaryOperationType) {
        if (unaryOperationType == null) {
            throw new IllegalArgumentException("unaryOperationType must not be null");
        }
        if (unaryOperationType.getOperationTypeMode() != OperationTypeMode.UNARY) {
            throw new IllegalArgumentException("unaryOperationType must be a unary operation type");
        }
        this.operand = operand;
        this.unaryOperationType = unaryOperationType;
    }

    @Override
    public Class<Object> getOperandsJavaType() {
        if (this.resultOperand == null) {
            this.calculateResultOperand();
        }
        return this.resultOperand.getOperandsJavaType();
    }

    @Override
    public Object value() {
        if (this.resultOperand == null) {
            this.calculateResultOperand();
        }
        return this.resultOperand.value();
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.OPERATION_RESULT;
    }

    private void calculateResultOperand() {
        this.resultOperand = this.unaryOperationType.doOperation(this.operand);
    }
}

