/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.templateblocks;

import io.toolisticon.aptk.templating.ParseUtilities;
import io.toolisticon.aptk.templating.exceptions.InvalidElseIfException;
import io.toolisticon.aptk.templating.exceptions.InvalidExpressionResult;
import io.toolisticon.aptk.templating.expressions.Expression;
import io.toolisticon.aptk.templating.expressions.ExpressionParser;
import io.toolisticon.aptk.templating.expressions.operands.Operand;
import io.toolisticon.aptk.templating.templateblocks.PlainTextTemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockBinder;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IfTemplateBlock
implements TemplateBlock {
    private static final String ELSE_OR_ELSEIF_DETECTION_REGEX = "[!][{](?:[ ]*?)(else(?:if){0,1})([ ]+(.*?)){0,1}(?:[ ]*?)[}]";
    private static final Pattern ELSE_OR_ELSEIF_DETECTION_PATTERN = Pattern.compile("[!][{](?:[ ]*?)(else(?:if){0,1})([ ]+(.*?)){0,1}(?:[ ]*?)[}]");
    private static final String ELSE_REGEX = "[!][{](?:[ ]*?)else(?:[ ]*?)[}]";
    private static final Pattern ELSE_PATTERN = Pattern.compile("[!][{](?:[ ]*?)else(?:[ ]*?)[}]");
    private static final String ELSEIF_REGEX = "[!][{]elseif[ ]+(.*?)[ ]*[}]";
    private static final Pattern ELSEIF_PATTERN = Pattern.compile("[!][{]elseif[ ]+(.*?)[ ]*[}]");
    private final String accessPath;
    private final String templateString;
    private TemplateBlockBinder elseBinder;
    private final List<IfStatement> ifStatements = new ArrayList<IfStatement>();

    public IfTemplateBlock(String attributeString, String templateString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("if command has no attribute string.");
        }
        this.accessPath = attributeString.trim();
        this.templateString = ParseUtilities.trimContentString(templateString);
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.IF;
    }

    @Override
    public String getContent(Map<String, Object> outerVariables) {
        for (IfStatement ifStatement : this.ifStatements) {
            Expression expression = ExpressionParser.parseExpression(ifStatement.getAccessPath(), outerVariables);
            Operand result = expression.evaluateExpression();
            if (!Boolean.class.equals(result.getOperandsJavaType()) && !Boolean.TYPE.equals(result.getOperandsJavaType())) {
                throw new InvalidExpressionResult("If statements expression '" + ifStatement.getAccessPath() + "' must evaluate to Boolean or boolean " + (result.getOperandsJavaType() != null ? ", but is of type " + result.getOperandsJavaType().getCanonicalName() : ""));
            }
            if (!((Boolean)result.value()).booleanValue()) continue;
            return ifStatement.getBinder().getContent(outerVariables).toString();
        }
        return this.elseBinder != null ? this.elseBinder.getContent(outerVariables) : "";
    }

    public void setBinder(TemplateBlockBinder binder) {
        this.elseBinder = new TemplateBlockBinder(null);
        TemplateBlockBinder currentIfBinder = new TemplateBlockBinder(null);
        this.ifStatements.add(new IfStatement(this.accessPath, currentIfBinder));
        Phase phase = Phase.ELSEIF;
        for (TemplateBlock templateBlock : binder.getTemplateBlocks()) {
            Matcher detectElseOrElseIfMatcher;
            if (phase == Phase.ELSEIF) {
                PlainTextTemplateBlock currentSegmentTemplateBlock;
                if (templateBlock.getTemplateBlockType() != TemplateBlockType.PLAIN_TEXT) {
                    currentIfBinder.addTemplateBlock(templateBlock);
                    continue;
                }
                detectElseOrElseIfMatcher = ELSE_OR_ELSEIF_DETECTION_PATTERN.matcher(templateBlock.getContent(null));
                boolean foundElseOrElseIf = detectElseOrElseIfMatcher.find();
                if (!foundElseOrElseIf) {
                    currentIfBinder.addTemplateBlock(templateBlock);
                    continue;
                }
                String contentString = templateBlock.getContent(null);
                int lastBeginIndex = 0;
                while (foundElseOrElseIf) {
                    if (phase != Phase.ELSEIF) {
                        String statementString = detectElseOrElseIfMatcher.group();
                        throw new InvalidElseIfException("Detected '" + statementString + "' after finishing else case which is syntactical incorrect");
                    }
                    currentSegmentTemplateBlock = new PlainTextTemplateBlock(contentString.substring(lastBeginIndex, detectElseOrElseIfMatcher.start()));
                    currentIfBinder.addTemplateBlock(currentSegmentTemplateBlock);
                    String commandString = detectElseOrElseIfMatcher.group();
                    String command = detectElseOrElseIfMatcher.group(1);
                    if (Phase.ELSEIF.getCommandString().equals(command)) {
                        Matcher elsifMatcher = ELSEIF_PATTERN.matcher(commandString);
                        if (!elsifMatcher.matches()) {
                            throw new InvalidElseIfException("Detected syntactical wrong elseif command : '" + commandString + "'");
                        }
                        String elseifAccessPath = elsifMatcher.group(1);
                        currentIfBinder = new TemplateBlockBinder(null);
                        this.ifStatements.add(new IfStatement(elseifAccessPath, currentIfBinder));
                    } else {
                        if (!ELSE_PATTERN.matcher(commandString).matches()) {
                            throw new InvalidElseIfException("Detected syntactical wrong else command : '" + commandString + "'");
                        }
                        phase = Phase.ELSE;
                    }
                    lastBeginIndex = detectElseOrElseIfMatcher.end();
                    foundElseOrElseIf = detectElseOrElseIfMatcher.find();
                }
                currentSegmentTemplateBlock = new PlainTextTemplateBlock(contentString.substring(lastBeginIndex));
                if (phase == Phase.ELSEIF) {
                    currentIfBinder.addTemplateBlock(currentSegmentTemplateBlock);
                    continue;
                }
                this.elseBinder.addTemplateBlock(currentSegmentTemplateBlock);
                continue;
            }
            if (templateBlock.getTemplateBlockType() != TemplateBlockType.PLAIN_TEXT) {
                this.elseBinder.addTemplateBlock(templateBlock);
                continue;
            }
            detectElseOrElseIfMatcher = ELSE_OR_ELSEIF_DETECTION_PATTERN.matcher(templateBlock.getContent(null));
            if (detectElseOrElseIfMatcher.find()) {
                String statementString = detectElseOrElseIfMatcher.group();
                throw new InvalidElseIfException("Detected '" + statementString + "' after finishing else case which is syntactical incorrect");
            }
            this.elseBinder.addTemplateBlock(templateBlock);
        }
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public TemplateBlockBinder getElseBinder() {
        return this.elseBinder;
    }

    public List<IfStatement> getIfStatements() {
        return this.ifStatements;
    }

    static class IfStatement {
        private final String accessPath;
        private final TemplateBlockBinder binder;

        IfStatement(String accessPath, TemplateBlockBinder binder) {
            this.accessPath = accessPath;
            this.binder = binder;
        }

        String getAccessPath() {
            return this.accessPath;
        }

        TemplateBlockBinder getBinder() {
            return this.binder;
        }
    }

    private static enum Phase {
        ELSEIF("elseif"),
        ELSE("else");

        private final String commandString;

        private Phase(String commandString) {
            this.commandString = commandString;
        }

        String getCommandString() {
            return this.commandString;
        }
    }
}

