/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.aptk.templating.templateblocks;

import io.toolisticon.aptk.templating.ParseUtilities;
import io.toolisticon.aptk.templating.exceptions.InvalidExpressionResult;
import io.toolisticon.aptk.templating.expressions.Expression;
import io.toolisticon.aptk.templating.expressions.ExpressionParser;
import io.toolisticon.aptk.templating.expressions.operands.Operand;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlock;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockBinder;
import io.toolisticon.aptk.templating.templateblocks.TemplateBlockType;
import java.util.Map;

public class IfTemplateBlock
implements TemplateBlock {
    private final String accessPath;
    private final String templateString;
    private TemplateBlockBinder binder;

    public IfTemplateBlock(String attributeString, String templateString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("if command has no attribute string.");
        }
        this.accessPath = attributeString.trim();
        this.templateString = ParseUtilities.trimContentString(templateString);
        this.binder = new TemplateBlockBinder(templateString);
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.IF;
    }

    @Override
    public String getContent(Map<String, Object> outerVariables) {
        Expression expression = ExpressionParser.parseExpression(this.accessPath, outerVariables);
        Operand result = expression.evaluateExpression();
        if (!Boolean.class.equals(result.getOperandsJavaType()) && !Boolean.TYPE.equals(result.getOperandsJavaType())) {
            throw new InvalidExpressionResult("If statements expression '" + this.accessPath + "' must evaluate to Boolean or boolean " + (result.getOperandsJavaType() != null ? ", but is of type " + result.getOperandsJavaType().getCanonicalName() : ""));
        }
        if (((Boolean)result.value()).booleanValue()) {
            return this.binder.getContent(outerVariables).toString();
        }
        return "";
    }

    public TemplateBlockBinder getBinder() {
        return this.binder;
    }

    public void setBinder(TemplateBlockBinder binder) {
        this.binder = binder;
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getTemplateString() {
        return this.templateString;
    }
}

