/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.cute;

import io.toolisticon.cute.CompileTestBuilderApi;
import io.toolisticon.cute.CuteApi;
import io.toolisticon.cute.GeneratedClassesTest;
import io.toolisticon.cute.GeneratedClassesTestForSpecificClass;
import io.toolisticon.cute.GeneratedFileObjectMatcher;
import io.toolisticon.cute.UnitTest;
import io.toolisticon.cute.UnitTestBase;
import io.toolisticon.cute.UnitTestForTestingAnnotationProcessors;
import io.toolisticon.fluapigen.api.FluentApiConverter;
import io.toolisticon.fluapigen.validation.api.HasNoArgConstructor;
import io.toolisticon.fluapigen.validation.api.NotNull;
import io.toolisticon.fluapigen.validation.api.ValidatorException;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class CompileTestBuilder {
    public static CompileTestBuilderApi.CompilationTestBuilder compilationTest() {
        return new TestTypeBuilderImpl(new ArrayDeque()).compilationTest();
    }

    public static CompileTestBuilderApi.UnitTestBuilder unitTest() {
        return new TestTypeBuilderImpl(new ArrayDeque()).unitTest();
    }

    static class TestTypeBuilderImpl
    implements CompileTestBuilderApi.TestTypeBuilder {
        final CompilerTestBBImpl backingBean;
        final Deque<Object> parentStack;

        private TestTypeBuilderImpl(Deque parentStack) {
            this.backingBean = new CompilerTestBBImpl();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        private TestTypeBuilderImpl(CompilerTestBBImpl backingBean, Deque parentStack) {
            this.backingBean = backingBean.cloneBackingBean();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder compilationTest() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.testType = CuteApi.TestType.BLACK_BOX;
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder unitTest() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.testType = CuteApi.TestType.UNIT;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }
    }

    static class CompilationTestCompileMessageCheckBuilderImpl
    implements CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder {
        final CompilerMessageCheckBBImpl backingBean;
        final Deque<Object> parentStack;

        private CompilationTestCompileMessageCheckBuilderImpl(Deque parentStack) {
            this.backingBean = new CompilerMessageCheckBBImpl();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        private CompilationTestCompileMessageCheckBuilderImpl(CompilerMessageCheckBBImpl backingBean, Deque parentStack) {
            this.backingBean = backingBean.cloneBackingBean();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder withLocale(Locale locale) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.withLocale = locale;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder thatIsEqualTo(String expectedMessage) {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerMessageCheckBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            currentBackingBean.getSearchString = new ArrayList<String>(Collections.singletonList(expectedMessage));
            currentBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.EQUALS;
            CompilerTestBBImpl backingBean0 = ((CompilerTestBBImpl)newStack.pop()).cloneBackingBean();
            backingBean0.compilerMessageChecks.add(currentBackingBean);
            return new CompilationTestBuilderImpl(backingBean0, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder atLineNumber(Long lineNumber) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atLine = new FluentApiConverter.LongToIntegerConverter().convert(lineNumber);
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder thatContains(String expectedContainedMessageToken) {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerMessageCheckBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            currentBackingBean.getSearchString = new ArrayList<String>(Collections.singletonList(expectedContainedMessageToken));
            currentBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl backingBean0 = ((CompilerTestBBImpl)newStack.pop()).cloneBackingBean();
            backingBean0.compilerMessageChecks.add(currentBackingBean);
            return new CompilationTestBuilderImpl(backingBean0, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder atSource(String source) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atSource = source;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder atColumnNumber(Long columnNumber) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atColumn = new FluentApiConverter.LongToIntegerConverter().convert(columnNumber);
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }
    }

    static class UnitTestCompileMessageCheckBuilderImpl
    implements CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder {
        final CompilerMessageCheckBBImpl backingBean;
        final Deque<Object> parentStack;

        private UnitTestCompileMessageCheckBuilderImpl(Deque parentStack) {
            this.backingBean = new CompilerMessageCheckBBImpl();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        private UnitTestCompileMessageCheckBuilderImpl(CompilerMessageCheckBBImpl backingBean, Deque parentStack) {
            this.backingBean = backingBean.cloneBackingBean();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder withLocale(Locale locale) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.withLocale = locale;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder thatIsEqualTo(String expectedMessage) {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerMessageCheckBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            currentBackingBean.getSearchString = new ArrayList<String>(Collections.singletonList(expectedMessage));
            currentBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.EQUALS;
            CompilerTestBBImpl backingBean0 = ((CompilerTestBBImpl)newStack.pop()).cloneBackingBean();
            backingBean0.compilerMessageChecks.add(currentBackingBean);
            return new UnitTestBuilderImpl(backingBean0, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder atLineNumber(Long lineNumber) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atLine = new FluentApiConverter.LongToIntegerConverter().convert(lineNumber);
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder thatContains(String expectedContainedMessageToken) {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerMessageCheckBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            currentBackingBean.getSearchString = new ArrayList<String>(Collections.singletonList(expectedContainedMessageToken));
            currentBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl backingBean0 = ((CompilerTestBBImpl)newStack.pop()).cloneBackingBean();
            backingBean0.compilerMessageChecks.add(currentBackingBean);
            return new UnitTestBuilderImpl(backingBean0, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder atSource(String source) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atSource = source;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder atColumnNumber(Long columnNumber) {
            CompilerMessageCheckBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.atColumn = new FluentApiConverter.LongToIntegerConverter().convert(columnNumber);
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, this.parentStack);
        }
    }

    static class UnitTestBuilderImpl
    implements CompileTestBuilderApi.UnitTestBuilder {
        final CompilerTestBBImpl backingBean;
        final Deque<Object> parentStack;

        private UnitTestBuilderImpl(Deque parentStack) {
            this.backingBean = new CompilerTestBBImpl();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        private UnitTestBuilderImpl(CompilerTestBBImpl backingBean, Deque parentStack) {
            this.backingBean = backingBean.cloneBackingBean();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatJavaFileObjectDoesntExist(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.DOESNT_EXIST;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public <ELEMENT_TYPE extends Element> CompileTestBuilderApi.UnitTestBuilder defineTest(Class<? extends Annotation> customAnnotationType, UnitTest<ELEMENT_TYPE> unitTest) {
            if (!new NotNull.ValidatorImpl().validate(customAnnotationType)) {
                throw new ValidatorException("Parameter 'customAnnotationType' of method 'defineTest' failed validation: @NotNull()");
            }
            if (!new NotNull.ValidatorImpl().validate(unitTest)) {
                throw new ValidatorException("Parameter 'unitTest' of method 'defineTest' failed validation: @NotNull()");
            }
            PassInConfigurationBBImpl inlineBackingBean = new PassInConfigurationBBImpl();
            inlineBackingBean.getAnnotationToScanFor = customAnnotationType;
            inlineBackingBean.getPassInElement = true;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.passInConfiguration = inlineBackingBean;
            nextBackingBean.unitTest = unitTest;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectNoteMessageThatContains(String ... noteChecksToSet) {
            if (!new NotNull.ValidatorImpl().validate((Object[])noteChecksToSet)) {
                throw new ValidatorException("Parameter 'noteChecksToSet' of method 'expectNoteMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(noteChecksToSet));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.NOTE;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatFileObjectDoesntExist(JavaFileManager.Location location, String packageName, String relativeName) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.DOESNT_EXIST;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectMandatoryWarningMessageThatContains(String ... mandatoryWarningChecks) {
            if (!new NotNull.ValidatorImpl().validate((Object[])mandatoryWarningChecks)) {
                throw new ValidatorException("Parameter 'mandatoryWarningChecks' of method 'expectMandatoryWarningMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(mandatoryWarningChecks));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.MANDATORY_WARNING;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder expectWarningMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.WARNING;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder useModules(String ... modules) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.modules = new HashSet<String>(Arrays.asList(modules));
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder useCompilerOptions(String ... compilerOptions) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerOptions = new ArrayList<String>(Arrays.asList(compilerOptions));
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder expectNoteMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.NOTE;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectErrorMessageThatContains(String ... errorChecksToSet) {
            if (!new NotNull.ValidatorImpl().validate((Object[])errorChecksToSet)) {
                throw new ValidatorException("Parameter 'errorChecksToSet' of method 'expectErrorMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(errorChecksToSet));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.ERROR;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder compilationShouldSucceed() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilationSucceeded = true;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatJavaFileObject(CuteApi.FileObjectCheckType checkType, JavaFileManager.Location location, String className, JavaFileObject.Kind kind, GeneratedFileObjectMatcher generatedJavaFileObjectCheck) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getCheckType = checkType;
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getGeneratedFileObjectMatcher = generatedJavaFileObjectCheck;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder useSource(JavaFileObject source) {
            if (!new NotNull.ValidatorImpl().validate((Object)source)) {
                throw new ValidatorException("Parameter 'source' of method 'useSource' failed validation: @NotNull()");
            }
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.sourceFiles = new HashSet<JavaFileObject>(Collections.singletonList(source));
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> CompileTestBuilderApi.UnitTestBuilder defineTestWithPassedInElement(Class<PROCESSOR_UNDER_TEST> processorUnderTestClass, Class<?> classToScan, Class<? extends Annotation> annotationToSearch, UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> unitTestForTestingAnnotationProcessors) {
            PassInConfigurationBBImpl inlineBackingBean = new PassInConfigurationBBImpl();
            inlineBackingBean.getPassedInProcessor = processorUnderTestClass;
            inlineBackingBean.getPassedInClass = classToScan;
            inlineBackingBean.getAnnotationToScanFor = annotationToSearch;
            inlineBackingBean.getPassInElement = true;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.passInConfiguration = inlineBackingBean;
            nextBackingBean.unitTest = unitTestForTestingAnnotationProcessors;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectWarningMessageThatContains(String ... warningChecks) {
            if (!new NotNull.ValidatorImpl().validate((Object[])warningChecks)) {
                throw new ValidatorException("Parameter 'warningChecks' of method 'expectWarningMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(warningChecks));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.WARNING;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder useProcessor(Class<Processor> processor) {
            if (!new NotNull.ValidatorImpl().validate(processor)) {
                throw new ValidatorException("Parameter 'processor' of method 'useProcessor' failed validation: @NotNull()");
            }
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.processors = new ArrayList<Class<Processor>>(Collections.singletonList(processor));
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder compilationShouldFail() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilationSucceeded = false;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public <ELEMENT_TYPE extends Element> CompileTestBuilderApi.UnitTestBuilder defineTestWithPassedInElement(Class<?> classToScan, Class<? extends Annotation> annotationToSearch, UnitTest<ELEMENT_TYPE> unitTest) {
            if (!new NotNull.ValidatorImpl().validate(classToScan)) {
                throw new ValidatorException("Parameter 'classToScan' of method 'defineTestWithPassedInElement' failed validation: @NotNull()");
            }
            if (!new NotNull.ValidatorImpl().validate(annotationToSearch)) {
                throw new ValidatorException("Parameter 'annotationToSearch' of method 'defineTestWithPassedInElement' failed validation: @NotNull()");
            }
            if (!new NotNull.ValidatorImpl().validate(unitTest)) {
                throw new ValidatorException("Parameter 'unitTest' of method 'defineTestWithPassedInElement' failed validation: @NotNull()");
            }
            PassInConfigurationBBImpl inlineBackingBean = new PassInConfigurationBBImpl();
            inlineBackingBean.getPassedInClass = classToScan;
            inlineBackingBean.getAnnotationToScanFor = annotationToSearch;
            inlineBackingBean.getPassInElement = true;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.passInConfiguration = inlineBackingBean;
            nextBackingBean.unitTest = unitTest;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder expectErrorMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.ERROR;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestCompileMessageCheckBuilder expectMandatoryWarningMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.MANDATORY_WARNING;
            return new UnitTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectedThrownException(Class<? extends Exception> expectedException) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.getExceptionIsThrown = expectedException;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> CompileTestBuilderApi.UnitTestBuilder defineTest(Class<PROCESSOR_UNDER_TEST> processorUnderTestClass, UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> unitTestForTestingAnnotationProcessors) {
            if (!new NotNull.ValidatorImpl().validate(processorUnderTestClass)) {
                throw new ValidatorException("Parameter 'processorUnderTestClass' of method 'defineTest' failed validation: @NotNull()");
            }
            if (!new HasNoArgConstructor.ValidatorImpl(new int[]{1}).validate(processorUnderTestClass)) {
                throw new ValidatorException("Parameter 'processorUnderTestClass' of method 'defineTest' failed validation: @HasNoArgConstructor()");
            }
            if (!new NotNull.ValidatorImpl().validate(unitTestForTestingAnnotationProcessors)) {
                throw new ValidatorException("Parameter 'unitTestForTestingAnnotationProcessors' of method 'defineTest' failed validation: @NotNull()");
            }
            PassInConfigurationBBImpl inlineBackingBean = new PassInConfigurationBBImpl();
            inlineBackingBean.getPassedInProcessor = processorUnderTestClass;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.passInConfiguration = inlineBackingBean;
            nextBackingBean.unitTest = unitTestForTestingAnnotationProcessors;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public <ELEMENT_TYPE extends Element> CompileTestBuilderApi.UnitTestBuilder defineTest(UnitTest<ELEMENT_TYPE> unitTest) {
            if (!new NotNull.ValidatorImpl().validate(unitTest)) {
                throw new ValidatorException("Parameter 'unitTest' of method 'defineTest' failed validation: @NotNull()");
            }
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.unitTest = unitTest;
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatJavaFileObjectExists(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public void executeTest() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            CompileTestBuilderApi.ExecuteTestCommand.myCommand(nextBackingBean);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName, GeneratedFileObjectMatcher ... generatedFileObjectMatcher) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getGeneratedFileObjectMatchers = generatedFileObjectMatcher;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilerTestBB createCompileTestConfiguration() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            return CompileTestBuilderApi.ClosingCommand.getConfig(nextBackingBean);
        }

        @Override
        public CompileTestBuilderApi.UnitTestBuilder expectThatGeneratedSourceFileExists(String className, GeneratedFileObjectMatcher generatedJavaFileObjectCheck) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getGeneratedFileObjectMatcher = generatedJavaFileObjectCheck;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            inlineBackingBean.getLocation = new CompileTestBuilderApi.StandardLocationStringToLocationConverter().convert("SOURCE_OUTPUT");
            inlineBackingBean.getKind = JavaFileObject.Kind.SOURCE;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new UnitTestBuilderImpl(nextBackingBean, this.parentStack);
        }
    }

    static class CompilationTestBuilderImpl
    implements CompileTestBuilderApi.CompilationTestBuilder {
        final CompilerTestBBImpl backingBean;
        final Deque<Object> parentStack;

        private CompilationTestBuilderImpl(Deque parentStack) {
            this.backingBean = new CompilerTestBBImpl();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        private CompilationTestBuilderImpl(CompilerTestBBImpl backingBean, Deque parentStack) {
            this.backingBean = backingBean.cloneBackingBean();
            this.parentStack = new ArrayDeque<Object>(parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatJavaFileObjectDoesntExist(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.DOESNT_EXIST;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectNoteMessageThatContains(String ... noteChecksToSet) {
            if (!new NotNull.ValidatorImpl().validate((Object[])noteChecksToSet)) {
                throw new ValidatorException("Parameter 'noteChecksToSet' of method 'expectNoteMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(noteChecksToSet));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.NOTE;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatFileObjectDoesntExist(JavaFileManager.Location location, String packageName, String relativeName) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.DOESNT_EXIST;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectMandatoryWarningMessageThatContains(String ... mandatoryWarningChecks) {
            if (!new NotNull.ValidatorImpl().validate((Object[])mandatoryWarningChecks)) {
                throw new ValidatorException("Parameter 'mandatoryWarningChecks' of method 'expectMandatoryWarningMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(mandatoryWarningChecks));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.MANDATORY_WARNING;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder expectWarningMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.WARNING;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder useModules(String ... modules) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.modules = new HashSet<String>(Arrays.asList(modules));
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder useCompilerOptions(String ... compilerOptions) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerOptions = new ArrayList<String>(Arrays.asList(compilerOptions));
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder expectNoteMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.NOTE;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectErrorMessageThatContains(String ... errorChecksToSet) {
            if (!new NotNull.ValidatorImpl().validate((Object[])errorChecksToSet)) {
                throw new ValidatorException("Parameter 'errorChecksToSet' of method 'expectErrorMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(errorChecksToSet));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.ERROR;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder compilationShouldSucceed() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilationSucceeded = true;
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatJavaFileObject(CuteApi.FileObjectCheckType checkType, JavaFileManager.Location location, String className, JavaFileObject.Kind kind, GeneratedFileObjectMatcher generatedJavaFileObjectCheck) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getCheckType = checkType;
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getGeneratedFileObjectMatcher = generatedJavaFileObjectCheck;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectWarningMessageThatContains(String ... warningChecks) {
            if (!new NotNull.ValidatorImpl().validate((Object[])warningChecks)) {
                throw new ValidatorException("Parameter 'warningChecks' of method 'expectWarningMessageThatContains' failed validation: @NotNull()");
            }
            CompilerMessageCheckBBImpl inlineBackingBean = new CompilerMessageCheckBBImpl();
            inlineBackingBean.getSearchString = new ArrayList<String>(Arrays.asList(warningChecks));
            inlineBackingBean.getKind = CuteApi.CompilerMessageKind.WARNING;
            inlineBackingBean.getComparisonType = CuteApi.CompilerMessageComparisonType.CONTAINS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilerMessageChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder compilationShouldFail() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.compilationSucceeded = false;
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder expectErrorMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.ERROR;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestCompileMessageCheckBuilder expectMandatoryWarningMessage() {
            ArrayDeque<Object> newStack = new ArrayDeque<Object>(this.parentStack);
            CompilerTestBBImpl currentBackingBean = this.backingBean.cloneBackingBean();
            newStack.push(currentBackingBean);
            CompilerMessageCheckBBImpl nextBackingBean = new CompilerMessageCheckBBImpl();
            nextBackingBean.getKind = CuteApi.CompilerMessageKind.MANDATORY_WARNING;
            return new CompilationTestCompileMessageCheckBuilderImpl(nextBackingBean, newStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder addSources(JavaFileObject ... sources) {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.sourceFiles.addAll(Arrays.asList(sources));
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatJavaFileObjectExists(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getKind = kind;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName, GeneratedFileObjectMatcher ... generatedFileObjectMatcher) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getGeneratedFileObjectMatchers = generatedFileObjectMatcher;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public void executeTest() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            CompileTestBuilderApi.ExecuteTestCommand.myCommand(nextBackingBean);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName) {
            GeneratedFileObjectCheckBBImpl inlineBackingBean = new GeneratedFileObjectCheckBBImpl();
            inlineBackingBean.getLocation = location;
            inlineBackingBean.getPackageName = packageName;
            inlineBackingBean.getRelativeName = relativeName;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.fileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder addProcessors(Class<? extends Processor> ... processorTypes) {
            if (!new HasNoArgConstructor.ValidatorImpl(new int[]{1}).validate((Object[])processorTypes)) {
                throw new ValidatorException("Parameter 'processorTypes' of method 'addProcessors' failed validation: @HasNoArgConstructor()");
            }
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.processors.addAll(Arrays.asList(new CompileTestBuilderApi.ProcessorConverter().convert(processorTypes)));
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }

        @Override
        public CompileTestBuilderApi.CompilerTestBB createCompileTestConfiguration() {
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            return CompileTestBuilderApi.ClosingCommand.getConfig(nextBackingBean);
        }

        @Override
        public CompileTestBuilderApi.CompilationTestBuilder expectThatGeneratedSourceFileExists(String className, GeneratedFileObjectMatcher generatedJavaFileObjectCheck) {
            GeneratedJavaFileObjectCheckBBImpl inlineBackingBean = new GeneratedJavaFileObjectCheckBBImpl();
            inlineBackingBean.getClassName = className;
            inlineBackingBean.getGeneratedFileObjectMatcher = generatedJavaFileObjectCheck;
            inlineBackingBean.getCheckType = CuteApi.FileObjectCheckType.EXISTS;
            inlineBackingBean.getLocation = new CompileTestBuilderApi.StandardLocationStringToLocationConverter().convert("SOURCE_OUTPUT");
            inlineBackingBean.getKind = JavaFileObject.Kind.SOURCE;
            CompilerTestBBImpl nextBackingBean = this.backingBean.cloneBackingBean();
            nextBackingBean.javaFileObjectChecks.add(inlineBackingBean);
            return new CompilationTestBuilderImpl(nextBackingBean, this.parentStack);
        }
    }

    static class GeneratedFileObjectCheckBBImpl
    implements CompileTestBuilderApi.GeneratedFileObjectCheckBB {
        JavaFileManager.Location getLocation;
        CuteApi.FileObjectCheckType getCheckType;
        String getRelativeName;
        String getPackageName;
        GeneratedFileObjectMatcher[] getGeneratedFileObjectMatchers;

        GeneratedFileObjectCheckBBImpl() {
        }

        private GeneratedFileObjectCheckBBImpl cloneBackingBean() {
            GeneratedFileObjectCheckBBImpl thisClone = new GeneratedFileObjectCheckBBImpl();
            thisClone.getLocation = this.getLocation;
            thisClone.getCheckType = this.getCheckType;
            thisClone.getRelativeName = this.getRelativeName;
            thisClone.getPackageName = this.getPackageName;
            thisClone.getGeneratedFileObjectMatchers = this.getGeneratedFileObjectMatchers != null ? (GeneratedFileObjectMatcher[])this.getGeneratedFileObjectMatchers.clone() : null;
            return thisClone;
        }

        public JavaFileManager.Location getLocation() {
            return this.getLocation;
        }

        public CuteApi.FileObjectCheckType getCheckType() {
            return this.getCheckType;
        }

        public String getRelativeName() {
            return this.getRelativeName;
        }

        public String getPackageName() {
            return this.getPackageName;
        }

        public GeneratedFileObjectMatcher[] getGeneratedFileObjectMatchers() {
            return this.getGeneratedFileObjectMatchers;
        }

        public String toString() {
            return "{\ngetLocation = " + (this.getLocation != null ? this.getLocation.toString() : "null") + ",\ngetCheckType = " + (this.getCheckType != null ? this.getCheckType.toString() : "null") + ",\ngetRelativeName = " + (this.getRelativeName != null ? this.getRelativeName.toString() : "null") + ",\ngetPackageName = " + (this.getPackageName != null ? this.getPackageName.toString() : "null") + ",\ngetGeneratedFileObjectMatchers = " + (this.getGeneratedFileObjectMatchers != null ? Arrays.stream(this.getGeneratedFileObjectMatchers).map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\n}";
        }
    }

    static class GeneratedJavaFileObjectCheckBBImpl
    implements CompileTestBuilderApi.GeneratedJavaFileObjectCheckBB {
        JavaFileManager.Location getLocation;
        CuteApi.FileObjectCheckType getCheckType;
        String getClassName;
        JavaFileObject.Kind getKind;
        GeneratedFileObjectMatcher getGeneratedFileObjectMatcher;
        GeneratedClassesTestForSpecificClass getGeneratedClassesTest;

        GeneratedJavaFileObjectCheckBBImpl() {
        }

        private GeneratedJavaFileObjectCheckBBImpl cloneBackingBean() {
            GeneratedJavaFileObjectCheckBBImpl thisClone = new GeneratedJavaFileObjectCheckBBImpl();
            thisClone.getLocation = this.getLocation;
            thisClone.getCheckType = this.getCheckType;
            thisClone.getClassName = this.getClassName;
            thisClone.getKind = this.getKind;
            thisClone.getGeneratedFileObjectMatcher = this.getGeneratedFileObjectMatcher;
            thisClone.getGeneratedClassesTest = this.getGeneratedClassesTest;
            return thisClone;
        }

        public JavaFileManager.Location getLocation() {
            return this.getLocation;
        }

        public CuteApi.FileObjectCheckType getCheckType() {
            return this.getCheckType;
        }

        public String getClassName() {
            return this.getClassName;
        }

        public JavaFileObject.Kind getKind() {
            return this.getKind;
        }

        public GeneratedFileObjectMatcher getGeneratedFileObjectMatcher() {
            return this.getGeneratedFileObjectMatcher;
        }

        public GeneratedClassesTestForSpecificClass getGeneratedClassesTest() {
            return this.getGeneratedClassesTest;
        }

        public String toString() {
            return "{\ngetLocation = " + (this.getLocation != null ? this.getLocation.toString() : "null") + ",\ngetCheckType = " + (this.getCheckType != null ? this.getCheckType.toString() : "null") + ",\ngetClassName = " + (this.getClassName != null ? this.getClassName.toString() : "null") + ",\ngetKind = " + (this.getKind != null ? this.getKind.toString() : "null") + ",\ngetGeneratedFileObjectMatcher = " + (this.getGeneratedFileObjectMatcher != null ? this.getGeneratedFileObjectMatcher.toString() : "null") + ",\ngetGeneratedClassesTest = " + (this.getGeneratedClassesTest != null ? this.getGeneratedClassesTest.toString() : "null") + ",\n}";
        }
    }

    static class CompilerMessageCheckBBImpl
    implements CompileTestBuilderApi.CompilerMessageCheckBB {
        Locale withLocale;
        List<String> getSearchString = new ArrayList<String>();
        Integer atColumn;
        String atSource;
        CuteApi.CompilerMessageComparisonType getComparisonType;
        CuteApi.CompilerMessageKind getKind;
        Integer atLine;

        CompilerMessageCheckBBImpl() {
        }

        private CompilerMessageCheckBBImpl cloneBackingBean() {
            CompilerMessageCheckBBImpl thisClone = new CompilerMessageCheckBBImpl();
            thisClone.withLocale = this.withLocale != null ? (Locale)this.withLocale.clone() : null;
            thisClone.getSearchString = this.getSearchString != null ? new ArrayList<String>(this.getSearchString) : null;
            thisClone.atColumn = this.atColumn;
            thisClone.atSource = this.atSource;
            thisClone.getComparisonType = this.getComparisonType;
            thisClone.getKind = this.getKind;
            thisClone.atLine = this.atLine;
            return thisClone;
        }

        public Locale withLocale() {
            return this.withLocale;
        }

        public List<String> getSearchString() {
            return this.getSearchString;
        }

        public Integer atColumn() {
            return this.atColumn;
        }

        public String atSource() {
            return this.atSource;
        }

        public CuteApi.CompilerMessageComparisonType getComparisonType() {
            return this.getComparisonType;
        }

        public CuteApi.CompilerMessageKind getKind() {
            return this.getKind;
        }

        public Integer atLine() {
            return this.atLine;
        }

        public String toString() {
            return "{\nwithLocale = " + (this.withLocale != null ? this.withLocale.toString() : "null") + ",\ngetSearchString = " + (this.getSearchString != null ? this.getSearchString.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\natColumn = " + (this.atColumn != null ? this.atColumn.toString() : "null") + ",\natSource = " + (this.atSource != null ? this.atSource.toString() : "null") + ",\ngetComparisonType = " + (this.getComparisonType != null ? this.getComparisonType.toString() : "null") + ",\ngetKind = " + (this.getKind != null ? this.getKind.toString() : "null") + ",\natLine = " + (this.atLine != null ? this.atLine.toString() : "null") + ",\n}";
        }
    }

    static class PassInConfigurationBBImpl
    implements CompileTestBuilderApi.PassInConfigurationBB {
        Class<? extends Annotation> getAnnotationToScanFor;
        boolean getPassInElement = false;
        Class<?> getPassedInClass;
        Class<? extends Processor> getPassedInProcessor;

        PassInConfigurationBBImpl() {
        }

        private PassInConfigurationBBImpl cloneBackingBean() {
            PassInConfigurationBBImpl thisClone = new PassInConfigurationBBImpl();
            thisClone.getAnnotationToScanFor = this.getAnnotationToScanFor;
            thisClone.getPassInElement = this.getPassInElement;
            thisClone.getPassedInClass = this.getPassedInClass;
            thisClone.getPassedInProcessor = this.getPassedInProcessor;
            return thisClone;
        }

        public Class<? extends Annotation> getAnnotationToScanFor() {
            return this.getAnnotationToScanFor;
        }

        public boolean getPassInElement() {
            return this.getPassInElement;
        }

        public Class<?> getPassedInClass() {
            return this.getPassedInClass;
        }

        public Class<? extends Processor> getPassedInProcessor() {
            return this.getPassedInProcessor;
        }

        public String toString() {
            return "{\ngetAnnotationToScanFor = " + (this.getAnnotationToScanFor != null ? this.getAnnotationToScanFor.toString() : "null") + ",\ngetPassInElement = " + this.getPassInElement + ",\ngetPassedInClass = " + (this.getPassedInClass != null ? this.getPassedInClass.toString() : "null") + ",\ngetPassedInProcessor = " + (this.getPassedInProcessor != null ? this.getPassedInProcessor.toString() : "null") + ",\n}";
        }
    }

    static class CompilerTestBBImpl
    implements CompileTestBuilderApi.CompilerTestBB {
        CuteApi.TestType testType;
        Boolean compilationSucceeded;
        List<Class<? extends Processor>> processors = new ArrayList<Class<? extends Processor>>();
        List<String> compilerOptions = new ArrayList<String>();
        CuteApi.UnitTestType getPassInType;
        List<CuteApi.GeneratedFileObjectCheckBB> fileObjectChecks = new ArrayList<CuteApi.GeneratedFileObjectCheckBB>();
        Set<String> modules = new HashSet<String>();
        List<GeneratedClassesTest> getGeneratedClassesTest = new ArrayList<GeneratedClassesTest>();
        Class<? extends Exception> getExceptionIsThrown;
        Set<JavaFileObject> sourceFiles = new HashSet<JavaFileObject>();
        List<CuteApi.GeneratedJavaFileObjectCheckBB> javaFileObjectChecks = new ArrayList<CuteApi.GeneratedJavaFileObjectCheckBB>();
        CuteApi.PassInConfigurationBB passInConfiguration;
        UnitTestBase unitTest;
        List<CuteApi.CompilerMessageCheckBB> compilerMessageChecks = new ArrayList<CuteApi.CompilerMessageCheckBB>();

        CompilerTestBBImpl() {
        }

        private CompilerTestBBImpl cloneBackingBean() {
            CompilerTestBBImpl thisClone = new CompilerTestBBImpl();
            thisClone.testType = this.testType;
            thisClone.compilationSucceeded = this.compilationSucceeded;
            thisClone.processors = this.processors != null ? new ArrayList<Class<? extends Processor>>(this.processors) : null;
            thisClone.compilerOptions = this.compilerOptions != null ? new ArrayList<String>(this.compilerOptions) : null;
            thisClone.getPassInType = this.getPassInType;
            thisClone.fileObjectChecks = this.fileObjectChecks != null ? (List)this.fileObjectChecks.stream().map(e -> ((GeneratedFileObjectCheckBBImpl)e).cloneBackingBean()).collect(Collectors.toCollection(ArrayList::new)) : null;
            thisClone.modules = this.modules != null ? new HashSet<String>(this.modules) : null;
            thisClone.getGeneratedClassesTest = this.getGeneratedClassesTest != null ? new ArrayList<GeneratedClassesTest>(this.getGeneratedClassesTest) : null;
            thisClone.getExceptionIsThrown = this.getExceptionIsThrown;
            thisClone.sourceFiles = this.sourceFiles != null ? new HashSet<JavaFileObject>(this.sourceFiles) : null;
            thisClone.javaFileObjectChecks = this.javaFileObjectChecks != null ? (List)this.javaFileObjectChecks.stream().map(e -> ((GeneratedJavaFileObjectCheckBBImpl)e).cloneBackingBean()).collect(Collectors.toCollection(ArrayList::new)) : null;
            thisClone.passInConfiguration = this.passInConfiguration != null ? ((PassInConfigurationBBImpl)this.passInConfiguration).cloneBackingBean() : null;
            thisClone.unitTest = this.unitTest;
            thisClone.compilerMessageChecks = this.compilerMessageChecks != null ? (List)this.compilerMessageChecks.stream().map(e -> ((CompilerMessageCheckBBImpl)e).cloneBackingBean()).collect(Collectors.toCollection(ArrayList::new)) : null;
            return thisClone;
        }

        public CuteApi.TestType testType() {
            return this.testType;
        }

        public Boolean compilationSucceeded() {
            return this.compilationSucceeded;
        }

        public List<Class<? extends Processor>> processors() {
            return this.processors;
        }

        public List<String> compilerOptions() {
            return this.compilerOptions;
        }

        public CuteApi.UnitTestType getPassInType() {
            return this.getPassInType;
        }

        public List<CuteApi.GeneratedFileObjectCheckBB> fileObjectChecks() {
            return this.fileObjectChecks;
        }

        public Set<String> modules() {
            return this.modules;
        }

        public List<GeneratedClassesTest> getGeneratedClassesTest() {
            return this.getGeneratedClassesTest;
        }

        public Class<? extends Exception> getExceptionIsThrown() {
            return this.getExceptionIsThrown;
        }

        public Set<JavaFileObject> sourceFiles() {
            return this.sourceFiles;
        }

        public List<CuteApi.GeneratedJavaFileObjectCheckBB> javaFileObjectChecks() {
            return this.javaFileObjectChecks;
        }

        public CuteApi.PassInConfigurationBB passInConfiguration() {
            return this.passInConfiguration;
        }

        public UnitTestBase unitTest() {
            return this.unitTest;
        }

        public List<CuteApi.CompilerMessageCheckBB> compilerMessageChecks() {
            return this.compilerMessageChecks;
        }

        public String toString() {
            return "{\ntestType = " + (this.testType != null ? this.testType.toString() : "null") + ",\ncompilationSucceeded = " + (this.compilationSucceeded != null ? this.compilationSucceeded.toString() : "null") + ",\nprocessors = " + (this.processors != null ? this.processors.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\ncompilerOptions = " + (this.compilerOptions != null ? this.compilerOptions.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\ngetPassInType = " + (this.getPassInType != null ? this.getPassInType.toString() : "null") + ",\nfileObjectChecks = " + (this.fileObjectChecks != null ? this.fileObjectChecks.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\nmodules = " + (this.modules != null ? this.modules.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\ngetGeneratedClassesTest = " + (this.getGeneratedClassesTest != null ? this.getGeneratedClassesTest.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\ngetExceptionIsThrown = " + (this.getExceptionIsThrown != null ? this.getExceptionIsThrown.toString() : "null") + ",\nsourceFiles = " + (this.sourceFiles != null ? this.sourceFiles.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\njavaFileObjectChecks = " + (this.javaFileObjectChecks != null ? this.javaFileObjectChecks.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\npassInConfiguration = " + (this.passInConfiguration != null ? this.passInConfiguration.toString() : "null") + ",\nunitTest = " + (this.unitTest != null ? this.unitTest.toString() : "null") + ",\ncompilerMessageChecks = " + (this.compilerMessageChecks != null ? this.compilerMessageChecks.stream().map(e -> e.toString()).collect(Collectors.joining(", ", "[", "]")) : "null") + ",\n}";
        }
    }
}

