/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.cute;

import io.toolisticon.cute.CompileTest;
import io.toolisticon.cute.CuteApi;
import io.toolisticon.cute.GeneratedFileObjectMatcher;
import io.toolisticon.cute.JavaFileObjectUtils;
import io.toolisticon.cute.PassIn;
import io.toolisticon.cute.UnitTest;
import io.toolisticon.cute.UnitTestForTestingAnnotationProcessors;
import io.toolisticon.cute.matchers.CoreGeneratedFileObjectMatchers;
import io.toolisticon.fluapigen.api.FluentApi;
import io.toolisticon.fluapigen.api.FluentApiBackingBean;
import io.toolisticon.fluapigen.api.FluentApiBackingBeanMapping;
import io.toolisticon.fluapigen.api.FluentApiCommand;
import io.toolisticon.fluapigen.api.FluentApiConverter;
import io.toolisticon.fluapigen.api.FluentApiImplicitValue;
import io.toolisticon.fluapigen.api.FluentApiImplicitValues;
import io.toolisticon.fluapigen.api.FluentApiInlineBackingBeanMapping;
import io.toolisticon.fluapigen.api.FluentApiInterface;
import io.toolisticon.fluapigen.api.FluentApiParentBackingBeanMapping;
import io.toolisticon.fluapigen.api.FluentApiRoot;
import io.toolisticon.fluapigen.api.MappingAction;
import io.toolisticon.fluapigen.api.TargetBackingBean;
import io.toolisticon.fluapigen.validation.api.HasNoArgConstructor;
import io.toolisticon.fluapigen.validation.api.NotNull;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@FluentApi(value="CompileTestBuilder")
public class CompileTestBuilderApi {

    public static class ProcessorConverter
    implements FluentApiConverter<Class<? extends Processor>[], Class<Processor>[]> {
        public Class<Processor>[] convert(Class<? extends Processor>[] processor) {
            return processor;
        }
    }

    public static class StandardLocationStringToLocationConverter
    implements FluentApiConverter<String, StandardLocation> {
        public StandardLocation convert(String s) {
            return StandardLocation.valueOf(s);
        }
    }

    @FluentApiCommand
    public static class ExecuteTestCommand {
        static void myCommand(CuteApi.CompilerTestBB backingBean) {
            if (backingBean.testType() == CuteApi.TestType.UNIT && backingBean.sourceFiles().size() == 0) {
                backingBean.sourceFiles().add(JavaFileObjectUtils.readFromResource((String)"/AnnotationProcessorUnitTestClass.java"));
            }
            if (backingBean.testType() == CuteApi.TestType.BLACK_BOX && backingBean.sourceFiles().size() == 0) {
                throw new IllegalStateException("There must be at least one source file present to execute a black box test!");
            }
            new CompileTest(backingBean).executeTest();
        }
    }

    @FluentApiCommand
    public static class ClosingCommand {
        public static CompilerTestBB getConfig(CompilerTestBB compilerTestBB) {
            return compilerTestBB;
        }
    }

    @FluentApiInterface(value=CompilerTestBB.class)
    @FluentApiRoot
    public static interface TestTypeBuilder {
        @FluentApiImplicitValue(id="testType", value={"BLACK_BOX"})
        public CompilationTestBuilder compilationTest();

        @FluentApiImplicitValue(id="testType", value={"UNIT"})
        public UnitTestBuilder unitTest();
    }

    @FluentApiInterface(value=CompilerMessageCheckBB.class)
    public static interface CompilationTestCompileMessageCheckBuilder
    extends CompileMessageCheckBuilder<CompilationTestBuilder, CompilationTestCompileMessageCheckBuilder> {
    }

    @FluentApiInterface(value=CompilerMessageCheckBB.class)
    public static interface UnitTestCompileMessageCheckBuilder
    extends CompileMessageCheckBuilder<UnitTestBuilder, UnitTestCompileMessageCheckBuilder> {
    }

    public static interface CompileMessageCheckBuilder<COMPILETESTBUILDER extends BasicBuilder<COMPILETESTBUILDER, COMPILERMESSAGEBUILDER>, COMPILERMESSAGEBUILDER extends CompileMessageCheckBuilder<COMPILETESTBUILDER, COMPILERMESSAGEBUILDER>> {
        public COMPILERMESSAGEBUILDER atLineNumber(@FluentApiBackingBeanMapping(value="atLine", converter=FluentApiConverter.LongToIntegerConverter.class) Long var1);

        public COMPILERMESSAGEBUILDER atColumnNumber(@FluentApiBackingBeanMapping(value="atColumn", converter=FluentApiConverter.LongToIntegerConverter.class) Long var1);

        public COMPILERMESSAGEBUILDER withLocale(@FluentApiBackingBeanMapping(value="withLocale") Locale var1);

        public COMPILERMESSAGEBUILDER atSource(@FluentApiBackingBeanMapping(value="atSource") String var1);

        @FluentApiParentBackingBeanMapping(value="compileMessageChecks", action=MappingAction.ADD)
        @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"CONTAINS"})
        public COMPILETESTBUILDER thatContains(@FluentApiBackingBeanMapping(value="searchString") String var1);

        @FluentApiParentBackingBeanMapping(value="compileMessageChecks", action=MappingAction.ADD)
        @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"EQUALS"})
        public COMPILETESTBUILDER thatIsEqualTo(@FluentApiBackingBeanMapping(value="searchString") String var1);
    }

    @FluentApiInterface(value=CompilerTestBB.class)
    public static interface UnitTestBuilder
    extends BasicBuilder<UnitTestBuilder, UnitTestCompileMessageCheckBuilder> {
        public UnitTestBuilder useProcessor(@FluentApiBackingBeanMapping(value="processors", action=MappingAction.SET) @NotNull Class<Processor> var1);

        public <ELEMENT_TYPE extends Element> UnitTestBuilder defineTest(@FluentApiBackingBeanMapping(value="unitTest") @NotNull UnitTest<ELEMENT_TYPE> var1);

        @FluentApiInlineBackingBeanMapping(value="passInConfiguration")
        @FluentApiImplicitValue(id="passInElement", value={"true"}, target=TargetBackingBean.INLINE)
        public <ELEMENT_TYPE extends Element> UnitTestBuilder defineTest(@FluentApiBackingBeanMapping(value="annotationToScanFor", target=TargetBackingBean.INLINE) @NotNull Class<? extends Annotation> var1, @FluentApiBackingBeanMapping(value="unitTest") @NotNull UnitTest<ELEMENT_TYPE> var2);

        default public <ELEMENT_TYPE extends Element> UnitTestBuilder defineTestWithPassedInElement(Class<?> classToScan, UnitTest<ELEMENT_TYPE> unitTest) {
            return this.defineTestWithPassedInElement(classToScan, PassIn.class, unitTest);
        }

        @FluentApiInlineBackingBeanMapping(value="passInConfiguration")
        @FluentApiImplicitValue(id="passInElement", value={"true"}, target=TargetBackingBean.INLINE)
        public <ELEMENT_TYPE extends Element> UnitTestBuilder defineTestWithPassedInElement(@FluentApiBackingBeanMapping(value="passedInClass", target=TargetBackingBean.INLINE) @NotNull Class<?> var1, @FluentApiBackingBeanMapping(value="annotationToScanFor", target=TargetBackingBean.INLINE) @NotNull Class<? extends Annotation> var2, @FluentApiBackingBeanMapping(value="unitTest") @NotNull UnitTest<ELEMENT_TYPE> var3);

        @FluentApiInlineBackingBeanMapping(value="passInConfiguration")
        public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> UnitTestBuilder defineTest(@FluentApiBackingBeanMapping(value="passedInProcessor", target=TargetBackingBean.INLINE) @NotNull @HasNoArgConstructor Class<PROCESSOR_UNDER_TEST> var1, @FluentApiBackingBeanMapping(value="unitTest") @NotNull UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> var2);

        default public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> UnitTestBuilder defineTest(Class<PROCESSOR_UNDER_TEST> processorUnderTestClass, Class<? extends Annotation> customAnnotationType, UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> unitTestForTestingAnnotationProcessors) {
            return this.defineTestWithPassedInElement(processorUnderTestClass, null, customAnnotationType, unitTestForTestingAnnotationProcessors);
        }

        default public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> UnitTestBuilder defineTestWithPassedInElement(Class<PROCESSOR_UNDER_TEST> processorUnderTestClass, Class<?> classToScan, UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> unitTestForTestingAnnotationProcessors) {
            return this.defineTestWithPassedInElement(processorUnderTestClass, classToScan, PassIn.class, unitTestForTestingAnnotationProcessors);
        }

        @FluentApiInlineBackingBeanMapping(value="passInConfiguration")
        @FluentApiImplicitValue(id="passInElement", value={"true"}, target=TargetBackingBean.INLINE)
        public <PROCESSOR_UNDER_TEST extends Processor, ELEMENT_TYPE extends Element> UnitTestBuilder defineTestWithPassedInElement(@FluentApiBackingBeanMapping(value="passedInProcessor", target=TargetBackingBean.INLINE) Class<PROCESSOR_UNDER_TEST> var1, @FluentApiBackingBeanMapping(value="passedInClass", target=TargetBackingBean.INLINE) Class<?> var2, @FluentApiBackingBeanMapping(value="annotationToScanFor", target=TargetBackingBean.INLINE) Class<? extends Annotation> var3, @FluentApiBackingBeanMapping(value="unitTest") UnitTestForTestingAnnotationProcessors<PROCESSOR_UNDER_TEST, ELEMENT_TYPE> var4);

        public UnitTestBuilder useSource(@FluentApiBackingBeanMapping(value="sourceFiles", action=MappingAction.SET) @NotNull JavaFileObject var1);

        default public UnitTestBuilder useSource(String resource) {
            return this.useSource(JavaFileObjectUtils.readFromResource((String)resource));
        }

        default public UnitTestBuilder useSource(String className, String content) {
            return this.useSource(JavaFileObjectUtils.readFromString((String)className, (String)content));
        }

        public UnitTestBuilder expectedThrownException(@FluentApiBackingBeanMapping(value="exceptionIsThrown") Class<? extends Exception> var1);

        @Override
        @FluentApiCommand(value=ExecuteTestCommand.class)
        public void executeTest();
    }

    @FluentApiInterface(value=CompilerTestBB.class)
    public static interface CompilationTestBuilder
    extends BasicBuilder<CompilationTestBuilder, CompilationTestCompileMessageCheckBuilder> {
        public CompilationTestBuilder addProcessors(Class<? extends Processor> ... var1);

        public CompilationTestBuilder addSources(JavaFileObject ... var1);

        default public CompilationTestBuilder addSources(String ... sources) {
            return this.addSources((JavaFileObject[])Arrays.stream(sources).map(e -> JavaFileObjectUtils.readFromResource((String)e)).toArray(JavaFileObject[]::new));
        }

        default public CompilationTestBuilder addSource(String clazzName, String content) {
            return this.addSources(JavaFileObjectUtils.readFromString((String)clazzName, (String)content));
        }
    }

    public static interface BasicBuilder<TEST_BUILDER extends BasicBuilder<TEST_BUILDER, COMPILERMESSAGECHECK>, COMPILERMESSAGECHECK extends CompileMessageCheckBuilder<TEST_BUILDER, COMPILERMESSAGECHECK>> {
        @FluentApiImplicitValue(id="compilationSucceeded", value={"true"})
        public TEST_BUILDER compilationShouldSucceed();

        @FluentApiImplicitValue(id="compilationSucceeded", value={"false"})
        public TEST_BUILDER compilationShouldFail();

        public TEST_BUILDER useCompilerOptions(String ... var1);

        public TEST_BUILDER useModules(String ... var1);

        @FluentApiImplicitValue(id="compilerMessageScope", value={"ERROR"}, target=TargetBackingBean.NEXT)
        public COMPILERMESSAGECHECK expectErrorMessage();

        @FluentApiImplicitValue(id="compilerMessageScope", value={"MANDATORY_WARNING"}, target=TargetBackingBean.NEXT)
        public COMPILERMESSAGECHECK expectMandatoryWarningMessage();

        @FluentApiImplicitValue(id="compilerMessageScope", value={"WARNING"}, target=TargetBackingBean.NEXT)
        public COMPILERMESSAGECHECK expectWarningMessage();

        @FluentApiImplicitValue(id="compilerMessageScope", value={"NOTE"}, target=TargetBackingBean.NEXT)
        public COMPILERMESSAGECHECK expectNoteMessage();

        @FluentApiInlineBackingBeanMapping(value="compileMessageChecks")
        @FluentApiImplicitValues(value={@FluentApiImplicitValue(id="compilerMessageScope", value={"WARNING"}, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"CONTAINS"}, target=TargetBackingBean.INLINE)})
        public TEST_BUILDER expectWarningMessageThatContains(String ... var1);

        @FluentApiInlineBackingBeanMapping(value="compileMessageChecks")
        @FluentApiImplicitValues(value={@FluentApiImplicitValue(id="compilerMessageScope", value={"MANDATORY_WARNING"}, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"CONTAINS"}, target=TargetBackingBean.INLINE)})
        public TEST_BUILDER expectMandatoryWarningMessageThatContains(String ... var1);

        @FluentApiInlineBackingBeanMapping(value="compileMessageChecks")
        @FluentApiImplicitValues(value={@FluentApiImplicitValue(id="compilerMessageScope", value={"ERROR"}, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"CONTAINS"}, target=TargetBackingBean.INLINE)})
        public TEST_BUILDER expectErrorMessageThatContains(String ... var1);

        @FluentApiInlineBackingBeanMapping(value="compileMessageChecks")
        @FluentApiImplicitValues(value={@FluentApiImplicitValue(id="compilerMessageScope", value={"NOTE"}, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="compilerMessageComparisonType", value={"CONTAINS"}, target=TargetBackingBean.INLINE)})
        public TEST_BUILDER expectNoteMessageThatContains(String ... var1);

        @FluentApiInlineBackingBeanMapping(value="fileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"EXISTS"}, target=TargetBackingBean.INLINE)
        public TEST_BUILDER expectThatFileObjectExists(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var1, @FluentApiBackingBeanMapping(value="packageName", target=TargetBackingBean.INLINE) String var2, @FluentApiBackingBeanMapping(value="relativeName", target=TargetBackingBean.INLINE) String var3);

        default public TEST_BUILDER expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName, FileObject expectedFileObject) {
            return this.expectThatFileObjectExists(location, packageName, relativeName, CoreGeneratedFileObjectMatchers.createBinaryMatcher((FileObject)expectedFileObject));
        }

        default public TEST_BUILDER expectThatFileObjectExists(JavaFileManager.Location location, String packageName, String relativeName, ExpectedFileObjectMatcherKind matcherKind, FileObject expectedFileObject) {
            if (matcherKind == null || expectedFileObject == null) {
                throw new IllegalArgumentException("Passed matcherKind and expectedFileObject must not be null!");
            }
            return this.expectThatFileObjectExists(location, packageName, relativeName, matcherKind.createMatcher(expectedFileObject));
        }

        @FluentApiInlineBackingBeanMapping(value="fileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"EXISTS"}, target=TargetBackingBean.INLINE)
        public TEST_BUILDER expectThatFileObjectExists(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var1, @FluentApiBackingBeanMapping(value="packageName", target=TargetBackingBean.INLINE) String var2, @FluentApiBackingBeanMapping(value="relativeName", target=TargetBackingBean.INLINE) String var3, GeneratedFileObjectMatcher ... var4);

        @FluentApiInlineBackingBeanMapping(value="fileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"DOESNT_EXIST"}, target=TargetBackingBean.INLINE)
        public TEST_BUILDER expectThatFileObjectDoesntExist(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var1, @FluentApiBackingBeanMapping(value="packageName", target=TargetBackingBean.INLINE) String var2, @FluentApiBackingBeanMapping(value="relativeName", target=TargetBackingBean.INLINE) String var3);

        default public TEST_BUILDER expectThatGeneratedSourceFileExists(String className) {
            return this.expectThatJavaFileObjectExists(StandardLocation.SOURCE_OUTPUT, className, JavaFileObject.Kind.SOURCE);
        }

        default public TEST_BUILDER expectThatGeneratedSourceFileExists(String className, JavaFileObject expectedJavaFileObject) {
            return this.expectThatGeneratedSourceFileExists(className, CoreGeneratedFileObjectMatchers.createBinaryMatcher((FileObject)expectedJavaFileObject));
        }

        default public TEST_BUILDER expectThatGeneratedClassExists(String className) {
            return this.expectThatJavaFileObjectExists(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS);
        }

        @FluentApiInlineBackingBeanMapping(value="javaFileObjectChecks")
        @FluentApiImplicitValues(value={@FluentApiImplicitValue(id="checkType", value={"EXISTS"}, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="location", value={"SOURCE_OUTPUT"}, converter=StandardLocationStringToLocationConverter.class, target=TargetBackingBean.INLINE), @FluentApiImplicitValue(id="kind", value={"SOURCE"}, target=TargetBackingBean.INLINE)})
        public TEST_BUILDER expectThatGeneratedSourceFileExists(@FluentApiBackingBeanMapping(value="className", target=TargetBackingBean.INLINE) String var1, @FluentApiBackingBeanMapping(value="generatedFileObjectMatcher", target=TargetBackingBean.INLINE) GeneratedFileObjectMatcher var2);

        default public TEST_BUILDER expectThatGeneratedSourceFileDoesntExist(String className) {
            return this.expectThatJavaFileObjectDoesntExist(StandardLocation.SOURCE_OUTPUT, className, JavaFileObject.Kind.SOURCE);
        }

        @FluentApiInlineBackingBeanMapping(value="javaFileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"EXISTS"}, target=TargetBackingBean.INLINE)
        public TEST_BUILDER expectThatJavaFileObjectExists(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var1, @FluentApiBackingBeanMapping(value="className", target=TargetBackingBean.INLINE) String var2, @FluentApiBackingBeanMapping(value="kind", target=TargetBackingBean.INLINE) JavaFileObject.Kind var3);

        default public TEST_BUILDER expectThatJavaFileObjectExists(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, JavaFileObject expectedJavaFileObject) {
            return this.expectThatJavaFileObjectExists(location, className, kind, ExpectedFileObjectMatcherKind.BINARY.createMatcher(expectedJavaFileObject));
        }

        default public TEST_BUILDER expectThatJavaFileObjectExists(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, ExpectedFileObjectMatcherKind expectedFileObjectMatcherKind, JavaFileObject expectedJavaFileObject) {
            return this.expectThatJavaFileObject(CuteApi.FileObjectCheckType.EXISTS, location, className, kind, CoreGeneratedFileObjectMatchers.createBinaryMatcher((FileObject)expectedJavaFileObject));
        }

        @FluentApiInlineBackingBeanMapping(value="javaFileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"EXISTS"}, target=TargetBackingBean.INLINE)
        default public TEST_BUILDER expectThatJavaFileObjectExists(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location location, @FluentApiBackingBeanMapping(value="className", target=TargetBackingBean.INLINE) String className, @FluentApiBackingBeanMapping(value="kind", target=TargetBackingBean.INLINE) JavaFileObject.Kind kind, @FluentApiBackingBeanMapping(value="generatedFileObjectMatcher", target=TargetBackingBean.INLINE) GeneratedFileObjectMatcher generatedJavaFileObjectCheck) {
            return this.expectThatJavaFileObject(CuteApi.FileObjectCheckType.EXISTS, location, className, kind, generatedJavaFileObjectCheck);
        }

        @FluentApiInlineBackingBeanMapping(value="javaFileObjectChecks")
        public TEST_BUILDER expectThatJavaFileObject(@FluentApiBackingBeanMapping(value="checkType", target=TargetBackingBean.INLINE) CuteApi.FileObjectCheckType var1, @FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var2, @FluentApiBackingBeanMapping(value="className", target=TargetBackingBean.INLINE) String var3, @FluentApiBackingBeanMapping(value="kind", target=TargetBackingBean.INLINE) JavaFileObject.Kind var4, @FluentApiBackingBeanMapping(value="generatedFileObjectMatcher", target=TargetBackingBean.INLINE) GeneratedFileObjectMatcher var5);

        @FluentApiInlineBackingBeanMapping(value="javaFileObjectChecks")
        @FluentApiImplicitValue(id="checkType", value={"DOESNT_EXIST"}, target=TargetBackingBean.INLINE)
        public TEST_BUILDER expectThatJavaFileObjectDoesntExist(@FluentApiBackingBeanMapping(value="location", target=TargetBackingBean.INLINE) JavaFileManager.Location var1, @FluentApiBackingBeanMapping(value="className", target=TargetBackingBean.INLINE) String var2, @FluentApiBackingBeanMapping(value="kind", target=TargetBackingBean.INLINE) JavaFileObject.Kind var3);

        @FluentApiCommand(value=ClosingCommand.class)
        public CompilerTestBB createCompileTestConfiguration();

        @FluentApiCommand(value=ExecuteTestCommand.class)
        public void executeTest();
    }

    public static enum ExpectedFileObjectMatcherKind {
        BINARY{

            @Override
            public <T extends FileObject> GeneratedFileObjectMatcher createMatcher(T expectedFileObject) {
                return CoreGeneratedFileObjectMatchers.createBinaryMatcher(expectedFileObject);
            }
        }
        ,
        TEXT_IGNORE_LINE_ENDINGS{

            @Override
            public <T extends FileObject> GeneratedFileObjectMatcher createMatcher(T expectedFileObject) {
                return CoreGeneratedFileObjectMatchers.createIgnoreLineEndingsMatcher(expectedFileObject);
            }
        };


        protected abstract <T extends FileObject> GeneratedFileObjectMatcher createMatcher(T var1);
    }

    @FluentApiBackingBean
    public static interface GeneratedFileObjectCheckBB
    extends CuteApi.GeneratedFileObjectCheckBB {
    }

    @FluentApiBackingBean
    public static interface GeneratedJavaFileObjectCheckBB
    extends CuteApi.GeneratedJavaFileObjectCheckBB {
    }

    @FluentApiBackingBean
    public static interface CompilerMessageCheckBB
    extends CuteApi.CompilerMessageCheckBB {
    }

    @FluentApiBackingBean
    public static interface PassInConfigurationBB
    extends CuteApi.PassInConfigurationBB {
    }

    @FluentApiBackingBean
    public static interface CompilerTestBB
    extends CuteApi.CompilerTestBB {
    }
}

