/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.cute.extension.api;

import io.toolisticon.cute.extension.api.ModuleSupportSpi;
import io.toolisticon.spiap.api.OutOfService;
import io.toolisticon.spiap.api.Service;
import io.toolisticon.spiap.api.Services;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;

public class ModuleSupportSpiServiceLocator {
    private static ClassLoader classLoaderToUse = null;
    private static List<ServiceImplementation> serviceImplementations;

    private static ServiceImplementation getServiceImplementationByAnnotations(ServiceImplementation previousConfig, ModuleSupportSpi serviceImpl) {
        try {
            Services servicesAnnotation;
            Service serviceAnnotation = serviceImpl.getClass().getAnnotation(Service.class);
            if (serviceAnnotation == null && (servicesAnnotation = serviceImpl.getClass().getAnnotation(Services.class)) != null) {
                for (Service service : servicesAnnotation.value()) {
                    if (!ModuleSupportSpi.class.equals((Object)service.value())) continue;
                    serviceAnnotation = service;
                    break;
                }
            }
            String id = serviceAnnotation != null ? serviceAnnotation.id() : null;
            String description = serviceAnnotation != null ? serviceAnnotation.description() : null;
            Integer priority = serviceAnnotation != null ? Integer.valueOf(serviceAnnotation.priority()) : null;
            boolean outOfService = serviceImpl.getClass().getAnnotation(OutOfService.class) != null;
            return new ServiceImplementation(previousConfig, id, description, priority, outOfService);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return previousConfig;
        }
    }

    private static ServiceImplementation getServiceImplementationByProperty(ServiceImplementation previousConfig, ModuleSupportSpi serviceImpl) {
        String propertyFileName = "/META-INF/spiap/" + ModuleSupportSpi.class.getCanonicalName() + "/" + serviceImpl.getClass().getCanonicalName() + ".properties";
        InputStream inputStream = ModuleSupportSpiServiceLocator.class.getResourceAsStream(propertyFileName);
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String id = properties.getProperty("id");
                String description = properties.getProperty("description");
                Integer priority = null;
                try {
                    String priorityString = properties.getProperty("priority");
                    if (priorityString != null) {
                        priority = Integer.valueOf(priorityString);
                    }
                }
                catch (NumberFormatException priorityString) {
                    // empty catch block
                }
                Boolean outOfService = null;
                String outOfServiceString = properties.getProperty("outOfService");
                if (outOfServiceString != null) {
                    outOfService = Boolean.valueOf(outOfServiceString);
                }
                return new ServiceImplementation(previousConfig, id, description, priority, outOfService);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return previousConfig;
    }

    public static ServiceImplementation getServiceImplementation(ModuleSupportSpi serviceImpl) {
        ServiceImplementation serviceKey = new ServiceImplementation(serviceImpl);
        serviceKey = ModuleSupportSpiServiceLocator.getServiceImplementationByAnnotations(serviceKey, serviceImpl);
        serviceKey = ModuleSupportSpiServiceLocator.getServiceImplementationByProperty(serviceKey, serviceImpl);
        return serviceKey;
    }

    public static List<ServiceImplementation> getServiceImplementations() {
        ModuleSupportSpiServiceLocator.locateAll();
        return new ArrayList<ServiceImplementation>(serviceImplementations);
    }

    public static ModuleSupportSpi locateById(String id) {
        if (id != null) {
            ModuleSupportSpiServiceLocator.locateAll();
            for (ServiceImplementation serviceImpl : serviceImplementations) {
                if (!id.equals(serviceImpl.getId())) continue;
                return serviceImpl.getServiceInstance();
            }
        }
        throw new ImplementationNotFoundException(id);
    }

    private ModuleSupportSpiServiceLocator() {
    }

    public static ModuleSupportSpi locate() {
        List<ModuleSupportSpi> services = ModuleSupportSpiServiceLocator.locateAll();
        return services.isEmpty() ? (ModuleSupportSpi)null : services.get(0);
    }

    public static List<ModuleSupportSpi> locateAll() {
        if (serviceImplementations == null) {
            Iterator<ModuleSupportSpi> iterator = ServiceLoader.load(ModuleSupportSpi.class, ModuleSupportSpiServiceLocator.getClassLoaderToUse()).iterator();
            ArrayList<ServiceImplementation> tmpServiceImplementations = new ArrayList<ServiceImplementation>();
            while (iterator.hasNext()) {
                try {
                    ModuleSupportSpi moduleSupportSpi = iterator.next();
                    ServiceImplementation serviceImpl = ModuleSupportSpiServiceLocator.getServiceImplementation(moduleSupportSpi);
                    if (serviceImpl.isOutOfService()) continue;
                    tmpServiceImplementations.add(serviceImpl);
                }
                catch (Error error) {
                    error.printStackTrace(System.err);
                }
            }
            Collections.sort(tmpServiceImplementations, new ServicePriorityComparator());
            serviceImplementations = tmpServiceImplementations;
        }
        ArrayList<ModuleSupportSpi> services = new ArrayList<ModuleSupportSpi>();
        for (ServiceImplementation serviceImplementation : serviceImplementations) {
            services.add(serviceImplementation.getServiceInstance());
        }
        return services;
    }

    public static void reloadServices() {
        serviceImplementations = null;
        ModuleSupportSpiServiceLocator.locateAll();
    }

    public static void setClassLoaderToUse(ClassLoader classLoader) {
        classLoaderToUse = classLoader;
    }

    private static ClassLoader getClassLoaderToUse() {
        return classLoaderToUse != null ? classLoaderToUse : Thread.currentThread().getContextClassLoader();
    }

    public static class ServicePriorityComparator
    implements Comparator<ServiceImplementation> {
        @Override
        public int compare(ServiceImplementation o1, ServiceImplementation o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1.priority == o2.priority) {
                return 0;
            }
            return o1.getPriority() < o2.getPriority() ? -1 : 1;
        }
    }

    public static class ServiceImplementation {
        private final String id;
        private final String description;
        private final int priority;
        private final boolean outOfService;
        private final ModuleSupportSpi serviceInstance;

        private ServiceImplementation(ModuleSupportSpi serviceInstance) {
            this.serviceInstance = serviceInstance;
            this.id = serviceInstance.getClass().getCanonicalName();
            this.description = "";
            this.priority = 0;
            this.outOfService = false;
        }

        private ServiceImplementation(ServiceImplementation previousConfig, String id, String description, Integer priority, Boolean outOfService) {
            this.serviceInstance = previousConfig.getServiceInstance();
            this.id = id != null ? id : previousConfig.getId();
            this.description = description != null ? description : previousConfig.getDescription();
            this.priority = priority != null ? priority.intValue() : previousConfig.getPriority();
            this.outOfService = outOfService != null ? outOfService.booleanValue() : previousConfig.isOutOfService();
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isOutOfService() {
            return this.outOfService;
        }

        public ModuleSupportSpi getServiceInstance() {
            return this.serviceInstance;
        }
    }

    public static class ImplementationNotFoundException
    extends RuntimeException {
        public ImplementationNotFoundException(String id) {
            super(String.format("Couldn't find implementation for spi ModuleSupportSpi with id : '%s'", id));
        }
    }
}

