/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.api;

public interface FluentApiConverter<SOURCE, TARGET> {
    public TARGET convert(SOURCE var1);

    public static class StringToDoubleConverter
    implements FluentApiConverter<String, Integer> {
        @Override
        public Integer convert(String value) {
            try {
                return value == null ? null : Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Passed String '" + value + "' can't be converted into an Integer");
            }
        }
    }

    public static class IntegerToDoubleConverter
    implements FluentApiConverter<Integer, Double> {
        @Override
        public Double convert(Integer value) {
            return value == null ? null : Double.valueOf(value.doubleValue());
        }
    }

    public static class IntegerToFloatConverter
    implements FluentApiConverter<Integer, Float> {
        @Override
        public Float convert(Integer value) {
            return value == null ? null : Float.valueOf(value.floatValue());
        }
    }

    public static class IntegerToLongConverter
    implements FluentApiConverter<Integer, Long> {
        @Override
        public Long convert(Integer value) {
            return value == null ? null : Long.valueOf(value.longValue());
        }
    }

    public static class LongToIntegerConverter
    implements FluentApiConverter<Long, Integer> {
        @Override
        public Integer convert(Long value) {
            return value == null ? null : Integer.valueOf(value.intValue());
        }
    }

    public static class NoConversion<TYPE>
    implements FluentApiConverter<TYPE, TYPE> {
        @Override
        public TYPE convert(TYPE type) {
            return type;
        }
    }
}

