/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.validation.api;

import io.toolisticon.fluapigen.validation.api.FluentApiValidator;
import io.toolisticon.fluapigen.validation.api.Validator;
import java.lang.reflect.Constructor;

@FluentApiValidator(value=ValidatorImpl.class, attributeNamesToConstructorParameterMapping={"modifier"})
public @interface HasNoArgConstructor {
    public int[] modifier() default {1};

    public static class ValidatorImpl
    implements Validator<Class> {
        private final int[] modifiers;

        public ValidatorImpl(int[] modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public boolean validate(Class obj) {
            if (obj != null) {
                try {
                    Constructor constructor = obj.getConstructor(new Class[0]);
                    for (int modifier : this.modifiers) {
                        if ((modifier & obj.getModifiers()) != 0) continue;
                        return false;
                    }
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            return true;
        }
    }
}

