/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.validation.api;

import io.toolisticon.fluapigen.validation.api.FluentApiValidator;
import io.toolisticon.fluapigen.validation.api.Validator;
import java.lang.reflect.Array;
import java.util.Collection;

@FluentApiValidator(value=ValidatorImpl.class, attributeNamesToConstructorParameterMapping={"value"})
public @interface MaxLength {
    public int value();

    public static class ValidatorImpl
    implements Validator<Object> {
        private final int maxLength;

        public ValidatorImpl(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public boolean validate(Object obj) {
            if (obj.getClass().isArray()) {
                return Array.getLength(obj) <= this.maxLength;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).size() <= this.maxLength;
            }
            if (obj instanceof String) {
                return ((String)obj).length() <= this.maxLength;
            }
            return obj != null;
        }
    }
}

