/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.validation.api;

import io.toolisticon.fluapigen.validation.api.FluentApiValidator;
import io.toolisticon.fluapigen.validation.api.Validator;
import java.lang.reflect.Array;
import java.util.Collection;

@FluentApiValidator(value=ValidatorImpl.class, attributeNamesToConstructorParameterMapping={"value"})
public @interface MinLength {
    public int value();

    public static class ValidatorImpl
    implements Validator<Object> {
        private final int minLength;

        public ValidatorImpl(int minLength) {
            this.minLength = minLength;
        }

        @Override
        public boolean validate(Object obj) {
            if (obj.getClass().isArray()) {
                return Array.getLength(obj) >= this.minLength;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).size() >= this.minLength;
            }
            if (obj instanceof String) {
                return ((String)obj).length() >= this.minLength;
            }
            return obj != null;
        }
    }
}

