/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.validation.api;

import io.toolisticon.fluapigen.validation.api.FluentApiValidator;
import io.toolisticon.fluapigen.validation.api.Validator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@FluentApiValidator(value=ValidatorImpl.class, attributeNamesToConstructorParameterMapping={"modifier"})
public @interface HasNoArgConstructor {
    public int[] modifier() default {1};

    public static class ValidatorImpl
    implements Validator<Class<?>> {
        private final int[] modifiers;

        public ValidatorImpl(int[] modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public boolean validate(Class<?> object) {
            if (object != null) {
                try {
                    if ((object.getModifiers() & 0x400) != 0) {
                        return false;
                    }
                    Constructor<?> constructor = object.getDeclaredConstructor(new Class[0]);
                    for (int modifier : this.modifiers) {
                        if ((modifier & object.getModifiers()) != 0) continue;
                        return false;
                    }
                }
                catch (NoSuchMethodException e) {
                    return object.getDeclaredConstructors().length == 0 && this.hasPublicModifier();
                }
            }
            return true;
        }

        boolean hasPublicModifier() {
            for (int modifier : this.modifiers) {
                if (modifier != 1) continue;
                return true;
            }
            return false;
        }
    }
}

