/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.fluapigen.validation.api;

import io.toolisticon.fluapigen.validation.api.FluentApiValidator;
import io.toolisticon.fluapigen.validation.api.Validator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@FluentApiValidator(value=ValidatorImpl.class, attributeNamesToConstructorParameterMapping={"value"})
public @interface Matches {
    public String value();

    public static class ValidatorImpl
    implements Validator<String> {
        private final String regularExpression;

        public ValidatorImpl(String regularExpression) {
            this.regularExpression = regularExpression;
        }

        @Override
        public boolean validate(String object) {
            return object == null || Pattern.compile(this.regularExpression).matcher(object).matches();
        }
    }
}

