/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.lib.avro.ext;

import io.toolisticon.lib.avro.AvroKotlinLib;
import io.toolisticon.lib.avro.ext.BytesExt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007J%\u0010\u0006\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0007J\f\u0010\u000b\u001a\u00020\f*\u00020\u0005H\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\u0005H\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010*\u00020\u00042\n\u0010\u0011\u001a\u00020\u0012\"\u00020\bH\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010*\u00020\u00052\n\u0010\u0011\u001a\u00020\u0012\"\u00020\bH\u0007J*\u0010\u0013\u001a\u00020\u0014*\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0014H\u0007\u00a8\u0006\u0018"}, d2={"Lio/toolisticon/lib/avro/ext/BytesExt;", "", "()V", "buffer", "Ljava/nio/ByteBuffer;", "", "extract", "position", "", "size", "(Ljava/nio/ByteBuffer;ILjava/lang/Integer;)[B", "isAvroSingleObjectEncoded", "", "readLong", "", "split", "", "indexes", "", "toHexString", "", "separator", "prefix", "postfix", "avro-kotlin"})
public final class BytesExt {
    @NotNull
    public static final BytesExt INSTANCE = new BytesExt();

    private BytesExt() {
    }

    @JvmStatic
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)24, null);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = " ";
        }
        if ((n & 2) != 0) {
            string2 = "[";
        }
        if ((n & 4) != 0) {
            string3 = "]";
        }
        return BytesExt.toHexString(byArray, string, string2, string3);
    }

    @JvmStatic
    @NotNull
    public static final ByteBuffer buffer(@NotNull byte[] $this$buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$buffer, (String)"<this>");
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(this)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<byte[]> split(@NotNull byte[] $this$split, int ... indexes) {
        void $this$fold$iv;
        boolean bl;
        int n;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$split, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
            int[] $this$none$iv = indexes;
            boolean $i$f$none = false;
            n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$none$iv[i];
                boolean bl2 = false;
                if (!(it < 0 || it > $this$split.length - 1)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-require-BytesExt$split$52 = false;
            String $i$a$-require-BytesExt$split$52 = "all indexes have to match '0 < index < size-1', was: indexes=" + ArraysKt.toList((int[])indexes) + ", size=" + $this$split.length;
            throw new IllegalArgumentException($i$a$-require-BytesExt$split$52.toString());
        }
        if (!Intrinsics.areEqual((Object)ArraysKt.toList((int[])indexes), (Object)ArraysKt.sorted((int[])indexes))) {
            boolean $i$a$-require-BytesExt$split$62 = false;
            String $i$a$-require-BytesExt$split$62 = "indexes must be ordered, was: " + ArraysKt.toList((int[])indexes);
            throw new IllegalArgumentException($i$a$-require-BytesExt$split$62.toString());
        }
        if (!(indexes.length == ArraysKt.distinct((int[])indexes).size())) {
            boolean $i$a$-require-BytesExt$split$72 = false;
            String $i$a$-require-BytesExt$split$72 = "indexes must be unique, was: " + ArraysKt.toList((int[])indexes);
            throw new IllegalArgumentException($i$a$-require-BytesExt$split$72.toString());
        }
        int[] $i$a$-require-BytesExt$split$72 = indexes;
        Pair initial$iv = TuplesKt.to((Object)0, (Object)CollectionsKt.emptyList());
        boolean $i$f$fold = false;
        Pair accumulator$iv = initial$iv;
        int n2 = ((void)$this$fold$iv).length;
        for (int i = 0; i < n2; ++i) {
            void nextIndex;
            void element$iv;
            void var10_17 = element$iv = $this$fold$iv[i];
            Pair pair = accumulator$iv;
            boolean bl3 = false;
            byte[] byArray = $this$split;
            int n3 = ((Number)pair.getFirst()).intValue();
            accumulator$iv = TuplesKt.to((Object)((int)nextIndex), (Object)CollectionsKt.plus((Collection)((Collection)pair.getSecond()), (Object)ArraysKt.copyOfRange((byte[])byArray, (int)n3, (int)nextIndex)));
        }
        Pair allButLast = accumulator$iv;
        byte[] byArray = $this$split;
        int n4 = ((Number)allButLast.getFirst()).intValue();
        n = $this$split.length;
        return CollectionsKt.plus((Collection)((Collection)allButLast.getSecond()), (Object)ArraysKt.copyOfRange((byte[])byArray, (int)n4, (int)n));
    }

    @JvmStatic
    @NotNull
    public static final List<byte[]> split(@NotNull ByteBuffer $this$split, int ... indexes) {
        Intrinsics.checkNotNullParameter((Object)$this$split, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        byte[] byArray = $this$split.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.array()");
        return BytesExt.split(byArray, Arrays.copyOf(indexes, indexes.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final byte[] extract(@NotNull ByteBuffer $this$extract, int position, @Nullable Integer size) {
        Intrinsics.checkNotNullParameter((Object)$this$extract, (String)"<this>");
        int originalPosition = $this$extract.position();
        try {
            $this$extract.position(position);
            if (!(size == null || size > 0)) {
                boolean $i$a$-require-BytesExt$extract$32 = false;
                String $i$a$-require-BytesExt$extract$32 = "size < 1: (" + size + " < 1)";
                throw new IllegalArgumentException($i$a$-require-BytesExt$extract$32.toString());
            }
            int maxSize = $this$extract.remaining();
            if (!(size == null || size <= maxSize)) {
                boolean bl = false;
                String string = "Cannot extract from position=" + position + ", size=" + size + ", remaining=" + $this$extract.remaining();
                throw new IllegalArgumentException(string.toString());
            }
            Integer n = size;
            byte[] bytes = new byte[n != null ? n.intValue() : $this$extract.remaining()];
            $this$extract.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            $this$extract.position(originalPosition);
        }
    }

    public static /* synthetic */ byte[] extract$default(ByteBuffer byteBuffer, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return BytesExt.extract(byteBuffer, n, n2);
    }

    @JvmStatic
    public static final long readLong(@NotNull byte[] $this$readLong) {
        Intrinsics.checkNotNullParameter((Object)$this$readLong, (String)"<this>");
        if (!($this$readLong.length == 8)) {
            boolean bl = false;
            String string = "Size must be exactly Long.SIZE_BYTES (8.";
            throw new IllegalArgumentException(string.toString());
        }
        return BytesExt.buffer($this$readLong).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    @JvmStatic
    public static final boolean isAvroSingleObjectEncoded(@NotNull ByteBuffer $this$isAvroSingleObjectEncoded) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAvroSingleObjectEncoded, (String)"<this>");
        try {
            bl = Arrays.equals(BytesExt.extract($this$isAvroSingleObjectEncoded, 0, AvroKotlinLib.AVRO_V1_HEADER.length), AvroKotlinLib.AVRO_V1_HEADER);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isAvroSingleObjectEncoded(@NotNull byte[] $this$isAvroSingleObjectEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvroSingleObjectEncoded, (String)"<this>");
        return BytesExt.isAvroSingleObjectEncoded(BytesExt.buffer($this$isAvroSingleObjectEncoded));
    }
}

