/*
 * Decompiled with CFR 0.152.
 */
package io.toolisticon.lib.avro.ext;

import io.toolisticon.lib.avro.AvroKotlinLib;
import io.toolisticon.lib.avro.ext.IoExt;
import io.toolisticon.lib.avro.fqn.SchemaFqn;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u00020\u00062\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0007J\u0014\u0010\u0012\u001a\u00020\u00062\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007J\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0006J#\u0010\u0018\u001a\u00020\u0019*\u00020\u00062\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\b\u001dJ\u0012\u0010\u001e\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\n\u0010!\u001a\u00020\"*\u00020\u0006J \u0010#\u001a\u00020 *\u00020\u00062\n\u0010\u001f\u001a\u00060 j\u0002`$2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010#\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001f\u001a\u00020 R\u0019\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00060\nj\u0002`\u000b*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lio/toolisticon/lib/avro/ext/SchemaExt;", "", "()V", "fileExtension", "", "Lio/toolisticon/lib/avro/FileExtension;", "Lorg/apache/avro/Schema;", "getFileExtension", "(Lorg/apache/avro/Schema;)Ljava/lang/String;", "fingerprint", "", "Lio/toolisticon/lib/avro/Fingerprint;", "getFingerprint", "(Lorg/apache/avro/Schema;)J", "path", "Ljava/nio/file/Path;", "getPath", "(Lorg/apache/avro/Schema;)Ljava/nio/file/Path;", "schemaForClass", "recordClass", "Ljava/lang/Class;", "Lkotlin/reflect/KClass;", "byteContent", "Ljava/io/ByteArrayInputStream;", "createGenericRecord", "Lorg/apache/avro/generic/GenericData$Record;", "receiver", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "file", "dir", "Ljava/io/File;", "fqn", "Lio/toolisticon/lib/avro/fqn/SchemaFqn;", "writeToDirectory", "Lio/toolisticon/lib/avro/Directory;", "avro-kotlin"})
public final class SchemaExt {
    @NotNull
    public static final SchemaExt INSTANCE = new SchemaExt();

    private SchemaExt() {
    }

    public final long getFingerprint(@NotNull Schema $this$fingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$fingerprint, (String)"<this>");
        return SchemaNormalization.parsingFingerprint64((Schema)$this$fingerprint);
    }

    @NotNull
    public final String getFileExtension(@NotNull Schema $this$fileExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$fileExtension, (String)"<this>");
        return "avsc";
    }

    @NotNull
    public final Path getPath(@NotNull Schema $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        String string = $this$path.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namespace");
        String string2 = $this$path.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return IoExt.INSTANCE.fqnToPath(string, string2, this.getFileExtension($this$path));
    }

    @NotNull
    public final ByteArrayInputStream byteContent(@NotNull Schema $this$byteContent) {
        Intrinsics.checkNotNullParameter((Object)$this$byteContent, (String)"<this>");
        String string = $this$byteContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.toString()");
        String string2 = string;
        Charset charset = AvroKotlinLib.INSTANCE.getUTF_8();
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new ByteArrayInputStream(byArray);
    }

    @NotNull
    public final Path file(@NotNull Schema $this$file, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return IoExt.INSTANCE.file(dir, this.getPath($this$file));
    }

    @NotNull
    public final Path writeToDirectory(@NotNull Schema $this$writeToDirectory, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        File file = this.file($this$writeToDirectory, dir).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(dir).toFile()");
        File target = file;
        String string = $this$writeToDirectory.toString(true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(true)");
        IoExt.INSTANCE.writeText(target, string);
        Path path2 = target.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"target.toPath()");
        return path2;
    }

    @NotNull
    public final GenericData.Record createGenericRecord(@NotNull Schema $this$createGenericRecord, @NotNull Function1<? super GenericData.Record, Unit> receiver) {
        GenericData.Record record;
        Intrinsics.checkNotNullParameter((Object)$this$createGenericRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
        GenericData.Record $this$createGenericRecord_u24lambda_u2d0 = record = new GenericData.Record($this$createGenericRecord);
        boolean bl = false;
        receiver.invoke((Object)$this$createGenericRecord_u24lambda_u2d0);
        return record;
    }

    @NotNull
    public final SchemaFqn fqn(@NotNull Schema $this$fqn) {
        Intrinsics.checkNotNullParameter((Object)$this$fqn, (String)"<this>");
        String string = $this$fqn.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namespace");
        String string2 = $this$fqn.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return new SchemaFqn(string, string2);
    }

    @NotNull
    public final File writeToDirectory(@NotNull Schema $this$writeToDirectory, @NotNull File dir, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String content = $this$writeToDirectory.toString(true);
        File file = IoExt.INSTANCE.file(dir, path2).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        String string = $this$writeToDirectory.toString(true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(true)");
        return IoExt.INSTANCE.writeText(file, string);
    }

    public static /* synthetic */ File writeToDirectory$default(SchemaExt schemaExt, Schema schema, File file, Path path2, int n, Object object) {
        if ((n & 2) != 0) {
            path2 = schemaExt.getPath(schema);
        }
        return schemaExt.writeToDirectory(schema, file, path2);
    }

    @JvmStatic
    @NotNull
    public static final Schema schemaForClass(@NotNull Class<?> recordClass) {
        Intrinsics.checkNotNullParameter(recordClass, (String)"recordClass");
        Schema schema = new SpecificData(recordClass.getClassLoader()).getSchema((Type)recordClass);
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"SpecificData(recordClass\u2026r).getSchema(recordClass)");
        return schema;
    }

    @JvmStatic
    @NotNull
    public static final Schema schemaForClass(@NotNull KClass<?> recordClass) {
        Intrinsics.checkNotNullParameter(recordClass, (String)"recordClass");
        return SchemaExt.schemaForClass(JvmClassMappingKt.getJavaClass(recordClass));
    }
}

