/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import io.trbl.bcpg.BcPGPUtils;
import io.trbl.bcpg.CryptoException;
import io.trbl.bcpg.SecretTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

class BcPGPDecryptVerifyTransform
implements SecretTransform {
    private final PGPPublicKey publicKey;
    private final PGPSecretKey secretKey;

    public BcPGPDecryptVerifyTransform(PGPPublicKey publicKey, PGPSecretKey secretKey) {
        this.publicKey = publicKey;
        this.secretKey = secretKey;
    }

    public void run(char[] passphrase, InputStream inputStream, OutputStream out) throws IOException, CryptoException {
        try {
            int ch;
            PGPEncryptedDataList enc = BcPGPUtils.extractPGPObject(PGPEncryptedDataList.class, inputStream);
            PGPPrivateKey privateKey = this.secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)new BouncyCastleProvider()).build(passphrase));
            Iterator it = enc.getEncryptedDataObjects();
            PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData)it.next();
            PGPObjectFactory pgpFact = new PGPObjectFactory(pbe.getDataStream((PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(privateKey)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPCompressedData c1 = (PGPCompressedData)pgpFact.nextObject();
            pgpFact = new PGPObjectFactory(c1.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPOnePassSignatureList p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
            PGPOnePassSignature ops = p1.get(0);
            PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
            InputStream dIn = p2.getInputStream();
            try {
                ops.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), this.publicKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while ((ch = dIn.read()) >= 0) {
                ops.update((byte)ch);
                out.write(ch);
            }
            PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
            if (ops.verify(p3.get(0))) {
                System.out.println("signature verified.");
            } else {
                System.out.println("signature verification failed.");
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

