/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import io.trbl.bcpg.BcPGPPublicKey;
import io.trbl.bcpg.BcPGPSecretKey;
import io.trbl.bcpg.BcPGPUtils;
import io.trbl.bcpg.CryptoException;
import io.trbl.bcpg.KeyFactory;
import io.trbl.bcpg.PublicKey;
import io.trbl.bcpg.SecretKey;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;

class BcPGPKeyFactory
implements KeyFactory {
    BcPGPKeyFactory() {
    }

    public SecretKey generateKeyPair(String id, char[] pass) throws CryptoException {
        try {
            RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
            kpg.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 2048, 12));
            BcPGPKeyPair keyPair = new BcPGPKeyPair(1, kpg.generateKeyPair(), new Date());
            PGPSignatureSubpacketGenerator signhashgen = new PGPSignatureSubpacketGenerator();
            signhashgen.setKeyFlags(true, 15);
            signhashgen.setPreferredCompressionAlgorithms(false, new int[]{1});
            signhashgen.setPreferredHashAlgorithms(false, new int[]{2});
            signhashgen.setPreferredSymmetricAlgorithms(false, new int[]{9});
            signhashgen.setFeature(false, (byte)1);
            PGPSignatureSubpacketGenerator enchashgen = new PGPSignatureSubpacketGenerator();
            enchashgen.setKeyFlags(false, 12);
            PGPDigestCalculator sha1Calc = new BcPGPDigestCalculatorProvider().get(2);
            PBESecretKeyEncryptor secretKeyEncryptor = new BcPBESecretKeyEncryptorBuilder(7, sha1Calc).build(pass);
            BcPGPContentSignerBuilder contentSigner = new BcPGPContentSignerBuilder(keyPair.getPublicKey().getAlgorithm(), 2);
            PGPKeyRingGenerator keyRingGen = new PGPKeyRingGenerator(19, (PGPKeyPair)keyPair, id, sha1Calc, signhashgen.generate(), null, (PGPContentSignerBuilder)contentSigner, secretKeyEncryptor);
            return new BcPGPSecretKey(keyRingGen.generateSecretKeyRing().getSecretKey());
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public PublicKey parsePublicKey(String inputStream) {
        return new BcPGPPublicKey(BcPGPUtils.extractPGPObject(PGPPublicKeyRing.class, inputStream).getPublicKey());
    }

    public SecretKey parseSecretKey(String inputStream) {
        return new BcPGPSecretKey(BcPGPUtils.extractPGPObject(PGPSecretKeyRing.class, inputStream).getSecretKey());
    }
}

