/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import io.trbl.bcpg.BcPGPDecryptVerifyTransform;
import io.trbl.bcpg.BcPGPPublicKey;
import io.trbl.bcpg.BcPGPSignEncryptTransform;
import io.trbl.bcpg.BcPGPUtils;
import io.trbl.bcpg.PublicKey;
import io.trbl.bcpg.SecretKey;
import io.trbl.bcpg.SecretTransform;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;

class BcPGPSecretKey
implements SecretKey {
    private final PGPSecretKey secretKey;

    public BcPGPSecretKey(PGPSecretKey pgpKey) {
        this.secretKey = pgpKey;
    }

    public String toArmoredString() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredStream = new ArmoredOutputStream((OutputStream)outputStream);
        BufferedOutputStream bufferedStream = new BufferedOutputStream((OutputStream)armoredStream);
        try {
            this.secretKey.encode((OutputStream)bufferedStream);
            bufferedStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return outputStream.toString();
    }

    public PublicKey getPublicKey() {
        return new BcPGPPublicKey(this.secretKey.getPublicKey());
    }

    public SecretTransform signEncryptFor(String publicKeyInputStream) throws IOException {
        return new BcPGPSignEncryptTransform(BcPGPUtils.extractPGPObject(PGPPublicKeyRing.class, publicKeyInputStream).getPublicKey(), this.secretKey);
    }

    public SecretTransform decryptVerifyFrom(String publicKeyInputStream) throws IOException {
        return new BcPGPDecryptVerifyTransform(BcPGPUtils.extractPGPObject(PGPPublicKeyRing.class, publicKeyInputStream).getPublicKey(), this.secretKey);
    }
}

