/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import io.trbl.bcpg.CryptoException;
import io.trbl.bcpg.SecretTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;

class BcPGPSignEncryptTransform
implements SecretTransform {
    private final PGPPublicKey publicKey;
    private final PGPSecretKey secretKey;

    public BcPGPSignEncryptTransform(PGPPublicKey publicKey, PGPSecretKey secretKey) {
        this.publicKey = publicKey;
        this.secretKey = secretKey;
    }

    public void run(char[] passphrase, InputStream inputStream, OutputStream outputStream) throws IOException, CryptoException {
        try {
            ArmoredOutputStream armor = new ArmoredOutputStream(outputStream);
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(7).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider((Provider)new BouncyCastleProvider()));
            encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(this.publicKey).setSecureRandom(new SecureRandom()).setProvider((Provider)new BouncyCastleProvider()));
            OutputStream encryptedOut = encryptedDataGenerator.open((OutputStream)armor, new byte[4096]);
            PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
            OutputStream compressedOut = compressedDataGenerator.open(encryptedOut, new byte[4096]);
            PGPPrivateKey privateKey = this.secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)new BouncyCastleProvider()).build(passphrase));
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(this.secretKey.getPublicKey().getAlgorithm(), 2).setProvider((Provider)new BouncyCastleProvider()));
            signatureGenerator.init(0, privateKey);
            Iterator it = this.secretKey.getPublicKey().getUserIDs();
            if (it.hasNext()) {
                PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
                spGen.setSignerUserID(false, (String)it.next());
                signatureGenerator.setHashedSubpackets(spGen.generate());
            }
            signatureGenerator.generateOnePassVersion(false).encode(compressedOut);
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
            OutputStream literalOut = literalDataGenerator.open(compressedOut, 'b', "", new Date(), new byte[4096]);
            byte[] buf = new byte[4096];
            int len = 0;
            while ((len = inputStream.read(buf)) > 0) {
                literalOut.write(buf, 0, len);
                signatureGenerator.update(buf, 0, len);
            }
            literalDataGenerator.close();
            signatureGenerator.generate().encode(compressedOut);
            compressedDataGenerator.close();
            encryptedDataGenerator.close();
            armor.close();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

