/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BcPGPUtils {
    BcPGPUtils() {
    }

    public static <T> T extractPGPObject(Class<T> type, String inputStream) {
        try {
            return BcPGPUtils.extractPGPObject(type, new ByteArrayInputStream(inputStream.getBytes()));
        }
        catch (IOException e) {
            throw new IllegalStateException("", e);
        }
    }

    public static <T> T extractPGPObject(Class<T> type, InputStream inputStream) throws IOException {
        Object object;
        PGPObjectFactory objectFactory = new PGPObjectFactory((InputStream)new ArmoredInputStream(inputStream), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        while ((object = objectFactory.nextObject()) != null) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return type.cast(object);
        }
        throw new IllegalArgumentException("Input text does not contain a PGP object");
    }
}

