/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.bcpg;

import io.trbl.bcpg.FingerprintFormat;

public class SimpleFingerprintFormat
implements FingerprintFormat {
    private final int minorGroupSize;
    private final String minorDelimiter;
    private final int majorGroupSize;
    private final String majorDelimiter;

    public SimpleFingerprintFormat() {
        this(0, "", 0, "");
    }

    public SimpleFingerprintFormat(int groupSize, String delimiter) {
        this(groupSize, delimiter, 0, "");
    }

    public SimpleFingerprintFormat(int minorGroupSize, String minorDelimiter, int majorGroupSize, String majorDelimiter) {
        this.minorGroupSize = minorGroupSize;
        this.minorDelimiter = minorDelimiter;
        this.majorGroupSize = majorGroupSize;
        this.majorDelimiter = majorDelimiter;
    }

    public String format(byte[] fingerprint) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < fingerprint.length; ++i) {
            if (i > 0) {
                if (this.majorGroupSize != 0 && i % this.majorGroupSize == 0) {
                    result.append(this.majorDelimiter);
                } else if (this.minorGroupSize != 0 && i % this.minorGroupSize == 0) {
                    result.append(this.minorDelimiter);
                }
            }
            result.append(String.format("%02X", fingerprint[i]));
        }
        return result.toString();
    }
}

