/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.blurhash;

final class Base83 {
    static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz#$%*+,-.:;=?@[]^_{|}~".toCharArray();

    private static int indexOf(char[] a, char key) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != key) continue;
            return i;
        }
        return -1;
    }

    static String encode(long value, int length) {
        char[] buffer = new char[length];
        int exp = 1;
        int i = 1;
        while (i <= length) {
            int digit = (int)(value / (long)exp % 83L);
            buffer[length - i] = ALPHABET[digit];
            ++i;
            exp *= 83;
        }
        return new String(buffer);
    }

    static int decode(String value) {
        int result = 0;
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            result = result * 83 + Base83.indexOf(ALPHABET, chars[i]);
        }
        return result;
    }

    private Base83() {
    }
}

