/*
 * Decompiled with CFR 0.152.
 */
package io.trbl.blurhash;

import io.trbl.blurhash.Base83;
import io.trbl.blurhash.Utils;
import java.awt.image.BufferedImage;

public final class BlurHash {
    private static double[] multiplyBasisFunction(int[] pixels, int width, int height, BasisFunction basisFunction) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = pixels[y * width + x];
                double basis = basisFunction.apply(x, y);
                r += basis * Utils.sRGBToLinear(pixel >> 16 & 0xFF);
                g += basis * Utils.sRGBToLinear(pixel >> 8 & 0xFF);
                b += basis * Utils.sRGBToLinear(pixel & 0xFF);
            }
        }
        double scale = 1.0 / (double)(width * height);
        return new double[]{r * scale, g * scale, b * scale};
    }

    private static long encodeDC(double[] value) {
        long r = Utils.linearTosRGB(value[0]);
        long g = Utils.linearTosRGB(value[1]);
        long b = Utils.linearTosRGB(value[2]);
        return (r << 16) + (g << 8) + b;
    }

    private static long encodeAC(double[] value, double maximumValue) {
        double quantR = Math.floor(Math.max(0.0, Math.min(18.0, Math.floor(Utils.signPow(value[0] / maximumValue, 0.5) * 9.0 + 9.5))));
        double quantG = Math.floor(Math.max(0.0, Math.min(18.0, Math.floor(Utils.signPow(value[1] / maximumValue, 0.5) * 9.0 + 9.5))));
        double quantB = Math.floor(Math.max(0.0, Math.min(18.0, Math.floor(Utils.signPow(value[2] / maximumValue, 0.5) * 9.0 + 9.5))));
        return Math.round(quantR * 19.0 * 19.0 + quantG * 19.0 + quantB);
    }

    public static String encode(BufferedImage bufferedImage) {
        return BlurHash.encode(bufferedImage, 4, 4);
    }

    public static String encode(BufferedImage bufferedImage, int componentX, int componentY) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int[] pixels = bufferedImage.getRGB(0, 0, width, height, null, 0, width);
        return BlurHash.encode(pixels, width, height, componentX, componentY);
    }

    public static String encode(int[] pixels, int width, int height, int componentX, int componentY) {
        double maximumValue;
        if (componentX < 1 || componentX > 9 || componentY < 1 || componentY > 9) {
            throw new IllegalArgumentException("Blur hash must have between 1 and 9 components");
        }
        if (width * height != pixels.length) {
            throw new IllegalArgumentException("Width and height must match the pixels array");
        }
        double[][] factors = new double[componentX * componentY][];
        for (int y = 0; y < componentY; ++y) {
            for (int x = 0; x < componentX; ++x) {
                double normalisation = x == 0 && y == 0 ? 1.0 : 2.0;
                double cx = x;
                double cy = y;
                BasisFunction basisFunction = (i, j) -> normalisation * Math.cos(Math.PI * cx * (double)i / (double)width) * Math.cos(Math.PI * cy * (double)j / (double)height);
                double[] factor = BlurHash.multiplyBasisFunction(pixels, width, height, basisFunction);
                factors[y * componentX + x] = factor;
            }
        }
        String hash = "";
        long sizeFlag = componentX - 1 + (componentY - 1) * 9;
        hash = hash + Base83.encode(sizeFlag, 1);
        if (factors.length > 1) {
            double actualMaximumValue = Utils.max(factors, 1, factors.length);
            double quantisedMaximumValue = Math.floor(Math.max(0.0, Math.min(82.0, Math.floor(actualMaximumValue * 166.0 - 0.5))));
            maximumValue = (quantisedMaximumValue + 1.0) / 166.0;
            hash = hash + Base83.encode(Math.round(quantisedMaximumValue), 1);
        } else {
            maximumValue = 1.0;
            hash = hash + Base83.encode(0L, 1);
        }
        double[] dc = factors[0];
        hash = hash + Base83.encode(BlurHash.encodeDC(dc), 4);
        for (int i2 = 1; i2 < factors.length; ++i2) {
            hash = hash + Base83.encode(BlurHash.encodeAC(factors[i2], maximumValue), 2);
        }
        return hash;
    }

    private BlurHash() {
    }

    @FunctionalInterface
    private static interface BasisFunction {
        public double apply(int var1, int var2);
    }
}

