/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.graphite;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import io.trino.benchto.driver.BenchmarkExecutionException;
import io.trino.benchto.driver.utils.TimeUtils;
import java.math.BigDecimal;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="graphite", value={"url"})
public class GraphiteClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteClient.class);
    @Value(value="${graphite.url}")
    private String graphiteURL;
    @Autowired
    private RestTemplate restTemplate;

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public void storeEvent(GraphiteEventRequest request) {
        LOGGER.debug("Storing graphite event: {}", (Object)request);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.graphiteURL).path("/events/");
        URI uri = uriBuilder.build().toUri();
        this.restTemplate.postForObject(uri, (Object)request, Object.class);
    }

    @Retryable(value={RestClientException.class, IncompleteDataException.class}, backoff=@Backoff(delay=5000L, multiplier=2.0), maxAttempts=4)
    public Map<String, double[]> loadMetrics(Map<String, String> metrics, long fromEpochSecond, long toEpochSecond) {
        URI uri = this.buildLoadMetricsURI(metrics, fromEpochSecond, toEpochSecond);
        LOGGER.debug("Loading metrics: {}", (Object)uri);
        ResponseEntity response = this.restTemplate.getForEntity(uri, GraphiteRenderResponseItem[].class);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new BenchmarkExecutionException("Could not load metrics: " + String.valueOf(metrics) + " - error: " + String.valueOf(response));
        }
        return Arrays.stream((GraphiteRenderResponseItem[])response.getBody()).collect(Collectors.toMap(GraphiteRenderResponseItem::getTarget, responseItem -> this.parseDataPoints(responseItem.datapoints)));
    }

    private URI buildLoadMetricsURI(Map<String, String> metrics, long fromEpochSecond, long toEpochSecond) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.graphiteURL).path("/render").queryParam("format", new Object[]{"json"}).queryParam("from", new Object[]{fromEpochSecond}).queryParam("until", new Object[]{toEpochSecond});
        for (Map.Entry<String, String> metric : metrics.entrySet()) {
            String metricQueryExpr = metric.getValue();
            String metricName = metric.getKey();
            uriBuilder.queryParam("target", new Object[]{String.format("alias(%s,'%s')", metricQueryExpr, metricName)});
        }
        return uriBuilder.build().toUri();
    }

    private double[] parseDataPoints(Double[][] inputDataPoints) {
        double[] dataPoints = new double[inputDataPoints.length];
        for (int i = 0; i < inputDataPoints.length; ++i) {
            Double value = inputDataPoints[i][0];
            if (value == null) {
                throw new IncompleteDataException("null data point returned from Graphite");
            }
            dataPoints[i] = value;
        }
        return dataPoints;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class GraphiteRenderResponseItem {
        public static final int DATA_POINT_VALUE_INDEX = 0;
        public static final int DATA_POINT_TIMESTAMP_INDEX = 1;
        private String target;
        private Double[][] datapoints;

        String getTarget() {
            return this.target;
        }
    }

    public static final class IncompleteDataException
    extends RuntimeException {
        public IncompleteDataException(String message) {
            super(message);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class GraphiteEventRequest {
        private String what;
        private String tags;
        private String data = "";
        private BigDecimal when;

        private GraphiteEventRequest() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("what", (Object)this.what).add("tags", (Object)this.tags).add("data", (Object)this.data).add("when", (Object)this.when).toString();
        }

        public static class GraphiteEventRequestBuilder {
            private final GraphiteEventRequest request = new GraphiteEventRequest();

            public GraphiteEventRequestBuilder() {
                this.when(TimeUtils.nowUtc());
            }

            public GraphiteEventRequestBuilder what(String what) {
                this.request.what = what;
                return this;
            }

            public GraphiteEventRequestBuilder tags(String ... tags) {
                this.request.tags = Joiner.on((String)" ").join((Object[])tags);
                return this;
            }

            public GraphiteEventRequestBuilder data(String data) {
                this.request.data = data;
                return this;
            }

            public GraphiteEventRequestBuilder when(ZonedDateTime zonedDateTime) {
                Objects.requireNonNull(zonedDateTime, "zonedDateTime cannot be null");
                this.request.when = new BigDecimal(String.format("%d.%d", zonedDateTime.toEpochSecond(), zonedDateTime.getNano() / 1000));
                return this;
            }

            public GraphiteEventRequest build() {
                return this.request;
            }
        }
    }
}

