/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners.profiler;

import com.google.common.util.concurrent.Futures;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.QueryExecution;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import io.trino.benchto.driver.listeners.profiler.QueryProfiler;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.profiler", name={"enabled"}, havingValue="true")
public class QueryProfilerExecutionListener
implements BenchmarkExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(QueryProfilerExecutionListener.class);
    @Autowired
    private List<QueryProfiler> profilers;
    @Value(value="${benchmark.feature.profiler.profiled-coordinator:#{null}}")
    @Nullable
    private String profiledCoordinator;
    @Value(value="${benchmark.feature.profiler.profiled-worker:#{null}}")
    @Nullable
    private String profiledWorker;

    public int getOrder() {
        return -100;
    }

    @Override
    public synchronized Future<?> benchmarkStarted(Benchmark benchmark) {
        return Futures.immediateVoidFuture();
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult result) {
        return Futures.immediateVoidFuture();
    }

    @Override
    public synchronized Future<?> executionStarted(QueryExecution execution) {
        LOG.info("Starting profilers... [benchmark=%s, query=%s]".formatted(execution.getBenchmark().getName(), execution.getQueryName()));
        if (this.profiledCoordinator != null) {
            for (QueryProfiler profiler : this.profilers) {
                try {
                    LOG.info("Starting profiler %s for coordinator [benchmark=%s, query=%s]".formatted(profiler.getClass().getSimpleName(), execution.getBenchmark().getName(), execution.getQueryName()));
                    profiler.start(this.profiledCoordinator, execution.getBenchmark().getName(), execution.getQueryName(), execution.getSequenceId());
                }
                catch (Exception e) {
                    LOG.error("Starting profiler %s for coordinator failed".formatted(profiler.getClass().getSimpleName()), (Throwable)e);
                }
            }
        }
        if (this.profiledWorker != null) {
            for (QueryProfiler profiler : this.profilers) {
                try {
                    LOG.info("Starting profiler %s for worker [benchmark=%s, query=%s]".formatted(profiler.getClass().getSimpleName(), execution.getBenchmark().getName(), execution.getQueryName()));
                    profiler.start(this.profiledWorker, execution.getBenchmark().getName(), execution.getQueryName(), execution.getSequenceId());
                }
                catch (Exception e) {
                    LOG.error("Starting profiler %s for worker failed".formatted(profiler.getClass().getSimpleName()), (Throwable)e);
                }
            }
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public synchronized Future<?> executionFinished(QueryExecutionResult result) {
        LOG.info("Stopping profilers... [benchmark=%s, query=%s]".formatted(result.getBenchmark().getName(), result.getQueryName()));
        if (this.profiledCoordinator != null) {
            for (QueryProfiler profiler : this.profilers) {
                try {
                    LOG.info("Stopping profiler %s for coordinator [benchmark=%s, query=%s]".formatted(profiler.toString(), result.getQueryExecution().getBenchmark().getName(), result.getQueryExecution().getQueryName()));
                    profiler.stop(this.profiledCoordinator, result.getBenchmark().getName(), result.getQueryName(), result.getQueryExecution().getSequenceId());
                }
                catch (Exception e) {
                    LOG.error("Stopping profiler %s for coordinator failed".formatted(profiler.toString()), (Throwable)e);
                }
            }
        }
        if (this.profiledWorker != null) {
            for (QueryProfiler profiler : this.profilers) {
                try {
                    LOG.info("Stopping profiler %s for worker [benchmark=%s, query=%s]".formatted(profiler.toString(), result.getQueryExecution().getBenchmark().getName(), result.getQueryExecution().getQueryName()));
                    profiler.stop(this.profiledWorker, result.getBenchmark().getName(), result.getQueryName(), result.getQueryExecution().getSequenceId());
                }
                catch (Exception e) {
                    LOG.error("Stopping profiler %s for worker failed".formatted(profiler.toString()), (Throwable)e);
                }
            }
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public Future<?> concurrencyTestExecutionFinished(List<QueryExecutionResult> executions) {
        return Futures.immediateVoidFuture();
    }
}

