/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.utils;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public final class PropertiesUtils {
    public static <T> T resolveEnvironmentProperties(ConfigurableEnvironment environment, Class<T> clazz) {
        return PropertiesUtils.resolveEnvironmentProperties(environment, clazz, "");
    }

    public static <T> T resolveEnvironmentProperties(ConfigurableEnvironment environment, Class<T> clazz, String prefix) {
        Object properties = BeanUtils.instantiateClass(clazz);
        Binder binder = Binder.get((Environment)environment);
        binder.bind(prefix, Bindable.ofInstance((Object)properties)).orElseThrow(() -> new FatalBeanException("Could not bind " + clazz + " properties"));
        return (T)properties;
    }

    public static List<Path> extractPaths(String paths) {
        return PropertiesUtils.splitProperty(paths).map(dirs -> dirs.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static Optional<List<String>> splitProperty(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return Optional.empty();
        }
        Iterable values = Splitter.on((String)",").trimResults().split((CharSequence)value);
        return Optional.of(ImmutableList.copyOf((Iterable)values));
    }

    private PropertiesUtils() {
    }
}

