/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver;

import com.google.common.base.Preconditions;
import io.trino.benchto.driver.FailedBenchmarkExecutionException;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.ExecutionDriver;
import io.trino.benchto.driver.execution.QueryExecutionDriver;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableRetry
@EnableAutoConfiguration(exclude={FreeMarkerAutoConfiguration.class, DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
@ComponentScan(basePackages={"io.trino.benchto"})
public class DriverApp {
    private static final Logger LOG = LoggerFactory.getLogger(DriverApp.class);

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = DriverApp.processArguments(args);
        SpringApplicationBuilder applicationBuilder = new SpringApplicationBuilder(new Class[]{DriverApp.class}).web(WebApplicationType.NONE).registerShutdownHook(false).properties(new String[0]);
        if (commandLine.hasOption("profile")) {
            applicationBuilder.profiles(new String[]{commandLine.getOptionValue("profile")});
        }
        if (commandLine.hasOption("profiles.directory")) {
            String profilesDirectory = commandLine.getOptionValue("profiles.directory");
            applicationBuilder.properties(new String[]{"spring.config.location=" + profilesDirectory});
        }
        try (ConfigurableApplicationContext ctx = applicationBuilder.run(new String[0]);){
            ExecutionDriver executionDriver = (ExecutionDriver)ctx.getBean(ExecutionDriver.class);
            Thread.currentThread().setName("main");
            executionDriver.execute();
        }
        catch (Throwable e) {
            DriverApp.logException(e);
            System.exit(1);
        }
    }

    private static CommandLine processArguments(String[] args) throws ParseException {
        DefaultParser defaultParser = new DefaultParser();
        Options options = DriverApp.createOptions();
        CommandLine commandLine = defaultParser.parse(options, args);
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("Benchto driver", options);
            System.exit(0);
        }
        DriverApp.exposeArgumentsAsPropertiesForSpring(commandLine);
        Preconditions.checkState((boolean)commandLine.getArgList().isEmpty(), (String)"Added extra non used arguments: %s", (Object)commandLine.getArgList());
        return commandLine;
    }

    private static void exposeArgumentsAsPropertiesForSpring(CommandLine commandLine) {
        for (Option option : commandLine.getOptions()) {
            System.setProperty(option.getLongOpt(), option.getValue());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        DriverApp.addOption(options, "sql", "DIRS", "sql queries directories (separated by commas)", "none");
        DriverApp.addOption(options, "benchmarks", "DIRS", "benchmark descriptors directories (separated by commas)", "none");
        DriverApp.addOption(options, "overrides", "PATH", "Path to benchmark overrides", "none");
        DriverApp.addOption(options, "activeBenchmarks", "BENCHMARK_NAME,...", "list of active benchmarks", "all benchmarks");
        DriverApp.addOption(options, "activeVariables", "VARIABLE_NAME=VARIABLE_VALUE,...", "list of active variables", "no filtering by variables");
        DriverApp.addOption(options, "executionSequenceId", "SEQUENCE_ID,...", "list of sequence ids of benchmark execution", "generated");
        DriverApp.addOption(options, "timeLimit", "DURATION", "amount of time while benchmarks will be executed", "unlimited");
        DriverApp.addOption(options, "profile", "PROFILE", "configuration profile", "none");
        DriverApp.addOption(options, "profiles.directory", "PROFILES_DIRECTORY", "configuration profiles directory", "none");
        DriverApp.addOption(options, "frequencyCheckEnabled", "boolean", "if set no fresh benchmark will be executed", "true");
        DriverApp.addOption(options, "benchmark-service.url", "String", "URL of Benchto Service", "http://localhost:8080");
        DriverApp.addOption(options, "query-results-dir", "RESULTS_DIR", "directory for query results", "results");
        DriverApp.addOption(options, "warmup", "boolean", "if set no benchmark results will be saved", "false");
        options.addOption("h", "help", false, "Display help message.");
        return options;
    }

    private static void addOption(Options options, String longOption, String arg, String description, String defaultValue) {
        options.addOption(Option.builder().longOpt(longOption).hasArg().desc(String.format("%s - %s (default: %s).", arg, description, defaultValue)).build());
    }

    private static void logException(Throwable e) {
        LOG.error("Benchmark execution failed: {}", (Object)e.getMessage(), (Object)e);
        if (e instanceof FailedBenchmarkExecutionException) {
            FailedBenchmarkExecutionException failedBenchmarkExecutionException = (FailedBenchmarkExecutionException)e;
            for (BenchmarkExecutionResult failedBenchmarkResult : failedBenchmarkExecutionException.getFailedBenchmarkResults()) {
                LOG.error("--------------------------------------------------------------------------");
                LOG.error("Failed benchmark: {}", (Object)failedBenchmarkResult.getBenchmark().getUniqueName());
                for (Exception failureCause : failedBenchmarkResult.getFailureCauses()) {
                    LOG.error("Cause: {}", (Object)failureCause.getMessage(), (Object)failureCause);
                }
            }
            LOG.error("Total benchmarks failed {} out of {}", (Object)failedBenchmarkExecutionException.getFailedBenchmarkResults().size(), (Object)failedBenchmarkExecutionException.getBenchmarksCount());
        }
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        return restTemplate;
    }

    @Bean
    public AsyncTaskExecutor defaultTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setMaxPoolSize(5);
        taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        taskExecutor.setAwaitTerminationSeconds(300);
        return taskExecutor;
    }

    @Bean
    public FreeMarkerConfigurationFactoryBean freemarkerConfiguration() {
        FreeMarkerConfigurationFactoryBean factory = new FreeMarkerConfigurationFactoryBean();
        factory.setDefaultEncoding("UTF-8");
        return factory;
    }

    @Bean
    public QueryExecutionDriver queryExecutionDriver() {
        return new QueryExecutionDriver();
    }
}

