/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners.profiler.jfr;

import io.trino.benchto.driver.listeners.profiler.QueryProfiler;
import io.trino.benchto.driver.listeners.profiler.jfr.JfrProfilerProperties;
import java.io.IOException;
import java.nio.file.Path;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.profiler.jfr", value={"enabled"}, havingValue="true")
public class JFRProfiler
implements QueryProfiler {
    private static final Logger LOG = LoggerFactory.getLogger(JFRProfiler.class);
    @Autowired
    JfrProfilerProperties profilerProperties;
    private static final String[] commandSignature = new String[]{"[Ljava.lang.String;"};

    @Override
    @Retryable(value={IOException.class}, backoff=@Backoff(value=200L), maxAttempts=2)
    public void start(String workerName, String benchmarkName, String queryName, int sequenceId) {
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", workerName, this.profilerProperties.getJmx().getPort());
        try (JMXConnector jmxConnector = JMXConnectorFactory.connect(new JMXServiceURL(url), null);){
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            String sessionName = this.createProfilingSessionName(benchmarkName, queryName, sequenceId);
            String jfrRecodingFile = Path.of(this.profilerProperties.getOutputPath().toString(), benchmarkName, "%s_%d.jfr".formatted(queryName, sequenceId)).toString();
            Object[] args = new Object[]{new String[]{"dumponexit=true", "filename=%s".formatted(jfrRecodingFile), "name=%s".formatted(sessionName)}};
            LOG.info("Starting recording JFR profile for query=%s, sequenceId=%d, jfr=%s at side %s".formatted(queryName, sequenceId, jfrRecodingFile, workerName));
            Object result = mBeanServerConnection.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "jfrStart", args, commandSignature);
            LOG.info("Result of starting is: '%s' at %s side".formatted(result, workerName));
        }
        catch (Exception e) {
            LOG.error("Starting JFR profiler for worker failed at %s side".formatted(workerName), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    @Retryable(value={IOException.class}, backoff=@Backoff(value=200L), maxAttempts=2)
    public void stop(String workerName, String benchmarkName, String queryName, int sequenceId) {
        String sessionName = this.createProfilingSessionName(benchmarkName, queryName, sequenceId);
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", workerName, this.profilerProperties.getJmx().getPort());
        try (JMXConnector jmxConnector = JMXConnectorFactory.connect(new JMXServiceURL(url), null);){
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            Object[] args = new Object[]{new String[]{"name=%s".formatted(sessionName)}};
            Object result = mBeanServerConnection.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "jfrStop", args, commandSignature);
            LOG.info("Result of stopping is: '%s' at %s side".formatted(result, workerName));
        }
        catch (Exception e) {
            LOG.error("Stopping JFR profiler for worker %s failed at %s side".formatted(workerName, workerName), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "jfr";
    }

    private String createProfilingSessionName(String benchmarkName, String queryName, int sequenceId) {
        return "%s__%s_%d".formatted(benchmarkName, queryName, sequenceId);
    }
}

