/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.presto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.trino.benchto.driver.Measurable;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.queryinfo.QueryCompletionEventProvider;
import io.trino.benchto.driver.presto.PrestoClient;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.presto", value={"query.completion.event.collection.enabled"})
public class PrestoQueryCompletionEventLoader
implements QueryCompletionEventProvider {
    @Autowired
    private PrestoClient prestoClient;

    @Override
    public CompletableFuture<Optional<String>> loadQueryCompletionEvent(Measurable measurable) {
        QueryExecutionResult executionResult;
        if (measurable instanceof QueryExecutionResult && (executionResult = (QueryExecutionResult)measurable).getPrestoQueryId().isPresent()) {
            Optional<String> queryCompletionEvent = this.prestoClient.getQueryCompletionEvent(executionResult.getPrestoQueryId().get());
            queryCompletionEvent = queryCompletionEvent.map(event -> {
                JsonElement root = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new StringReader((String)event)));
                JsonObject rootObject = root.getAsJsonObject();
                JsonObject statistics = rootObject.getAsJsonObject("statistics");
                statistics.remove("operatorSummaries");
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setLenient(true);
                try {
                    Streams.write((JsonElement)root, (JsonWriter)jsonWriter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return stringWriter.toString();
            });
            return CompletableFuture.completedFuture(queryCompletionEvent);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }
}

