/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.trino.benchto.driver.graphite.GraphiteProperties;
import io.trino.benchto.driver.utils.PropertiesUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class BenchmarkProperties {
    @Value(value="${sql}")
    private String sqlDirs;
    @Value(value="${benchmarks}")
    private String benchmarksDirs;
    @Value(value="${presto.url}")
    private String prestoURL;
    @Value(value="${presto.httpEventListenerPort:#{null}}")
    private Integer prestoHttpEventListenerPort;
    @Value(value="${presto.username:#{null}}")
    private String prestoUsername;
    @Value(value="${benchmark-service.url}")
    private String serviceUrl;
    @Value(value="${overrides:#{null}}")
    private String overridesPath;
    @Value(value="${activeBenchmarks:#{null}}")
    private String activeBenchmarks;
    @Value(value="${activeVariables:#{null}}")
    private String activeVariables;
    @Value(value="${executionSequenceId:#{null}}")
    private String executionSequenceId;
    @Value(value="${environment.name}")
    private String environmentName;
    @Value(value="${macroExecutions.healthCheck:#{null}}")
    private String healthCheckMacros;
    @Value(value="${queryRepetitionScope:BENCHMARK}")
    private QueryRepetitionScope queryRepetitionScope;
    @Value(value="${macroExecutions.beforeAll:#{null}}")
    private String beforeAllMacros;
    @Value(value="${macroExecutions.afterAll:#{null}}")
    private String afterAllMacros;
    @Value(value="${timeLimit:#{null}}")
    private String timeLimit;
    @Value(value="${frequencyCheckEnabled:true}")
    private String frequencyCheckEnabled;
    @Value(value="${query-results-dir}")
    private String queryResultsDir;
    @Value(value="${warmup:false}")
    private String warmup;
    @Autowired
    private GraphiteProperties graphiteProperties;

    public List<Path> sqlFilesDirs() {
        return PropertiesUtils.extractPaths(this.sqlDirs);
    }

    public List<Path> benchmarksFilesDirs() {
        return PropertiesUtils.extractPaths(this.benchmarksDirs);
    }

    public String getServiceURL() {
        return this.serviceUrl;
    }

    public String getPrestoURL() {
        return this.prestoURL;
    }

    public Optional<String> getPrestoHttpEventListenerURL() {
        if (this.prestoHttpEventListenerPort == null) {
            return Optional.empty();
        }
        return Optional.of(UriComponentsBuilder.fromUriString((String)this.prestoURL).port(this.prestoHttpEventListenerPort.intValue()).build().toUriString());
    }

    public Optional<String> getPrestoUsername() {
        return Optional.ofNullable(this.prestoUsername);
    }

    public Optional<Path> getOverridesPath() {
        return Optional.ofNullable(this.overridesPath).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public Optional<List<String>> getExecutionSequenceId() {
        return PropertiesUtils.splitProperty(this.executionSequenceId);
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public Optional<List<String>> getActiveBenchmarks() {
        return PropertiesUtils.splitProperty(this.activeBenchmarks);
    }

    public Optional<Map<String, String>> getActiveVariables() {
        Optional<List<String>> variables = PropertiesUtils.splitProperty(this.activeVariables);
        if (!variables.isPresent()) {
            return Optional.empty();
        }
        Map<String, String> variablesMap = variables.get().stream().map(variable -> {
            ImmutableList variablePairList = ImmutableList.copyOf((Iterable)Splitter.on((String)"=").trimResults().split((CharSequence)variable));
            Preconditions.checkState((variablePairList.size() == 2 ? 1 : 0) != 0, (String)"Incorrect format of variable: '%s', while proper format is 'key=value'", (Object)variable);
            return variablePairList;
        }).collect(Collectors.toMap(variableList -> (String)variableList.get(0), variableList -> (String)variableList.get(1)));
        return Optional.of(variablesMap);
    }

    public Optional<Duration> getTimeLimit() {
        return Optional.ofNullable(this.timeLimit).map(Duration::parse);
    }

    public Path getQueryResultsDir() {
        return Paths.get(this.queryResultsDir, new String[0]);
    }

    public QueryRepetitionScope getQueryRepetitionScope() {
        return this.queryRepetitionScope;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("sqlDirs", (Object)this.sqlDirs).add("benchmarksDirs", (Object)this.benchmarksDirs).add("executionSequenceId", (Object)this.executionSequenceId).add("environmentName", (Object)this.environmentName).add("graphiteProperties", (Object)this.graphiteProperties).add("frequencyCheck", (Object)this.frequencyCheckEnabled).add("queryResultsDir", (Object)this.queryResultsDir);
        this.addForToStringOptionalField(toStringHelper, "activeBenchmarks", this.getActiveBenchmarks());
        this.addForToStringOptionalField(toStringHelper, "activeVariables", this.getActiveVariables());
        this.addForToStringOptionalField(toStringHelper, "beforeAllMacros", this.getBeforeAllMacros());
        this.addForToStringOptionalField(toStringHelper, "afterAllMacros", this.getAfterAllMacros());
        this.addForToStringOptionalField(toStringHelper, "healthCheckMacros", this.getHealthCheckMacros());
        this.addForToStringOptionalField(toStringHelper, "timeLimit", this.getTimeLimit());
        return toStringHelper.toString();
    }

    private void addForToStringOptionalField(MoreObjects.ToStringHelper toStringHelper, String fieldName, Optional optionalField) {
        optionalField.ifPresent(value -> toStringHelper.add(fieldName, value));
    }

    public Optional<List<String>> getHealthCheckMacros() {
        return PropertiesUtils.splitProperty(this.healthCheckMacros);
    }

    public Optional<List<String>> getBeforeAllMacros() {
        return PropertiesUtils.splitProperty(this.beforeAllMacros);
    }

    public Optional<List<String>> getAfterAllMacros() {
        return PropertiesUtils.splitProperty(this.afterAllMacros);
    }

    public boolean isFrequencyCheckEnabled() {
        return this.parseBoolean(this.frequencyCheckEnabled);
    }

    public boolean isWarmup() {
        return this.parseBoolean(this.warmup);
    }

    private boolean parseBoolean(String booleanString) {
        if (booleanString.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (booleanString.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        throw new IllegalStateException(String.format("Incorrect boolean value: %s.", booleanString));
    }

    public static enum QueryRepetitionScope {
        BENCHMARK,
        SUITE;

    }
}

