/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.Query;
import io.trino.benchto.driver.loader.SqlStatementGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryExecution {
    private final Benchmark benchmark;
    private final Query query;
    private final int sequenceId;
    private final String statement;

    public QueryExecution(Benchmark benchmark, Query query, int sequenceId, SqlStatementGenerator sqlStatementGenerator) {
        this.benchmark = Objects.requireNonNull(benchmark);
        this.query = Objects.requireNonNull(query);
        this.sequenceId = sequenceId;
        this.statement = this.generateQuerySqlStatement(sqlStatementGenerator);
    }

    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    public String getQueryName() {
        return this.query.getName();
    }

    public Query getQuery() {
        return this.query;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getStatement() {
        return this.statement;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("run", this.sequenceId).toString();
    }

    private String generateQuerySqlStatement(SqlStatementGenerator sqlStatementGenerator) {
        ImmutableMap variables = ImmutableMap.builder().put((Object)"execution_sequence_id", (Object)Integer.toString(this.getSequenceId())).putAll(this.getBenchmark().getNonReservedKeywordVariables()).build();
        List<String> sqlQueries = sqlStatementGenerator.generateQuerySqlStatement(this.getQuery(), (Map<String, ?>)variables);
        Preconditions.checkState((sqlQueries.size() == 1 ? 1 : 0) != 0, (Object)"Multiple statements in one query file are not supported");
        return sqlQueries.get(0);
    }
}

