/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.execution;

import io.trino.benchto.driver.execution.QueryExecution;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.utils.QueryUtils;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.TrinoResultSet;
import io.trino.jdbc.TrinoStatement;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionDriver {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutionDriver.class);

    public QueryExecutionResult execute(QueryExecution queryExecution, Connection connection, Optional<Path> resultFile) throws SQLException {
        QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder = (QueryExecutionResult.QueryExecutionResultBuilder)new QueryExecutionResult.QueryExecutionResultBuilder(queryExecution).startTimer();
        String sqlStatement = queryExecution.getStatement();
        if (QueryUtils.isSelectQuery(sqlStatement)) {
            return this.executeSelectQuery(connection, queryExecutionResultBuilder, sqlStatement, resultFile);
        }
        return this.executeUpdateQuery(connection, queryExecutionResultBuilder, sqlStatement, resultFile);
    }

    private QueryExecutionResult executeSelectQuery(Connection connection, QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder, String sqlStatement, Optional<Path> resultFile) throws SQLException {
        try (Statement statement = connection.createStatement();){
            QueryExecutionResult queryExecutionResult;
            block15: {
                ResultSet resultSet = statement.executeQuery(sqlStatement);
                try {
                    int rowsCount = resultFile.isPresent() ? QueryUtils.compareRows(resultFile.get(), resultSet) : QueryUtils.fetchRows(sqlStatement, resultSet);
                    try {
                        if (resultSet.isWrapperFor(TrinoResultSet.class)) {
                            TrinoResultSet trinoResultSet = resultSet.unwrap(TrinoResultSet.class);
                            queryExecutionResultBuilder.setPrestoQueryId(trinoResultSet.getQueryId());
                            queryExecutionResultBuilder.setPrestoQueryStats(trinoResultSet.getStats());
                        }
                    }
                    catch (AbstractMethodError | Exception e) {
                        LOG.warn("Driver ({}) does not support isWrapperFor/unwrap method", (Object)connection);
                    }
                    queryExecutionResult = (QueryExecutionResult)((QueryExecutionResult.QueryExecutionResultBuilder)queryExecutionResultBuilder.setRowsCount(rowsCount).endTimer()).build();
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return queryExecutionResult;
        }
    }

    private QueryExecutionResult executeUpdateQuery(Connection connection, QueryExecutionResult.QueryExecutionResultBuilder queryExecutionResultBuilder, String sqlStatement, Optional<Path> resultFile) throws SQLException {
        try (Statement statement = connection.createStatement();){
            if (statement.isWrapperFor(TrinoStatement.class)) {
                TrinoStatement trinoStatement = statement.unwrap(TrinoStatement.class);
                trinoStatement.setProgressMonitor(stats -> queryExecutionResultBuilder.setPrestoQueryId(stats.getQueryId()).setPrestoQueryStats((QueryStats)stats));
            }
            int rowCount = statement.executeUpdate(sqlStatement);
            resultFile.ifPresent(path -> QueryUtils.compareCount(path, rowCount));
            QueryExecutionResult queryExecutionResult = (QueryExecutionResult)((QueryExecutionResult.QueryExecutionResultBuilder)queryExecutionResultBuilder.setRowsCount(rowCount).endTimer()).build();
            return queryExecutionResult;
        }
    }
}

