/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.graphite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.trino.benchto.driver.Measurable;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.ExecutionSynchronizer;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.graphite.GraphiteClient;
import io.trino.benchto.driver.graphite.GraphiteProperties;
import io.trino.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import io.trino.benchto.driver.service.Measurement;
import jakarta.annotation.PostConstruct;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="benchmark.feature.graphite", value={"metrics.collection.enabled"})
public class GraphiteMetricsLoader
implements PostExecutionMeasurementProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteMetricsLoader.class);
    @Autowired
    private GraphiteClient graphiteClient;
    @Autowired
    private GraphiteProperties graphiteProperties;
    @Autowired
    private ExecutionSynchronizer executionSynchronizer;
    private Map<String, String> queryMetrics;

    @PostConstruct
    public void initQueryMetrics() {
        this.queryMetrics = Maps.newHashMap();
        this.graphiteProperties.getCpuGraphiteExpr().ifPresent(value -> this.queryMetrics.put("cpu", (String)value));
        this.graphiteProperties.getMemoryGraphiteExpr().ifPresent(value -> this.queryMetrics.put("memory", (String)value));
        this.graphiteProperties.getNetworkGraphiteExpr().ifPresent(value -> this.queryMetrics.put("network", (String)value));
        this.graphiteProperties.getNetworkGraphiteExpr().ifPresent(value -> this.queryMetrics.put("network_total", String.format("integral(%s)", value)));
        Preconditions.checkState((!this.queryMetrics.isEmpty() ? 1 : 0) != 0, (Object)"No graphite metrics (graphite.metrics.*) provided for measurement collection");
    }

    @Override
    public CompletableFuture<List<Measurement>> loadMeasurements(Measurable measurable) {
        ZonedDateTime to;
        long toEpochSecond;
        if (!this.shouldLoadGraphiteMetrics(measurable)) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        long fromEpochSecond = measurable.getUtcStart().toEpochSecond();
        if (fromEpochSecond >= (toEpochSecond = (to = measurable.getUtcEnd().minus(this.graphiteProperties.getGraphiteResolutionSeconds(), ChronoUnit.SECONDS)).toEpochSecond())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.executionSynchronizer.execute(to.plus(this.graphiteProperties.getGraphiteMetricsDelay()).toInstant(), () -> this.doLoadMeasurements(fromEpochSecond, toEpochSecond));
    }

    private List<Measurement> doLoadMeasurements(long fromEpochSecond, long toEpochSecond) {
        double[] metricValues;
        LOG.debug("Loading metrics {} - from: {}, to: {}", new Object[]{this.queryMetrics, fromEpochSecond, toEpochSecond});
        Map<String, double[]> loadedMetrics = this.graphiteClient.loadMetrics(this.queryMetrics, fromEpochSecond, toEpochSecond);
        ArrayList measurements = Lists.newArrayList();
        if (this.graphiteProperties.getCpuGraphiteExpr().isPresent() && loadedMetrics.containsKey("cpu")) {
            this.addMeanMaxMeasurements(loadedMetrics, measurements, "cpu", "PERCENT");
        }
        if (this.graphiteProperties.getMemoryGraphiteExpr().isPresent() && loadedMetrics.containsKey("memory")) {
            this.addMeanMaxMeasurements(loadedMetrics, measurements, "memory", "PERCENT");
        }
        if (this.graphiteProperties.getMemoryGraphiteExpr().isPresent() && loadedMetrics.containsKey("network")) {
            this.addMeanMaxMeasurements(loadedMetrics, measurements, "network", "BYTES");
        }
        if (this.graphiteProperties.getMemoryGraphiteExpr().isPresent() && loadedMetrics.containsKey("network_total") && (metricValues = loadedMetrics.get("network_total")).length > 0) {
            double totalBytes = this.getLastValueGreaterThanZero(metricValues);
            measurements.add(Measurement.measurement("cluster-network_total", "BYTES", totalBytes));
        }
        return measurements;
    }

    private boolean shouldLoadGraphiteMetrics(Measurable measurable) {
        if (!measurable.isSuccessful()) {
            return false;
        }
        if (measurable instanceof QueryExecutionResult && measurable.getBenchmark().isSerial()) {
            return true;
        }
        return measurable instanceof BenchmarkExecutionResult && measurable.getBenchmark().isConcurrent();
    }

    private void addMeanMaxMeasurements(Map<String, double[]> loadedMetrics, List<Measurement> measurements, String metricName, String unit) {
        Optional<StatisticalSummary> statistics = this.getStats(loadedMetrics, metricName);
        if (statistics.isPresent()) {
            measurements.add(Measurement.measurement("cluster-" + metricName + "_max", unit, statistics.get().getMax()));
            measurements.add(Measurement.measurement("cluster-" + metricName + "_mean", unit, statistics.get().getMean()));
        }
    }

    private Optional<StatisticalSummary> getStats(Map<String, double[]> loadedMetrics, String metricName) {
        double[] metricValues = loadedMetrics.get(metricName);
        if (metricValues.length >= 2) {
            return Optional.of(new DescriptiveStatistics(metricValues));
        }
        if (metricValues.length == 1) {
            double value = metricValues[0];
            return Optional.of(new StatisticalSummaryValues(value, 0.0, 1L, value, value, value));
        }
        return Optional.empty();
    }

    private double getLastValueGreaterThanZero(double[] metricValues) {
        for (int i = metricValues.length - 1; i >= 0; --i) {
            if (!(metricValues[i] > 0.0)) continue;
            return metricValues[i];
        }
        return 0.0;
    }
}

