/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.graphite;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GraphiteProperties {
    @Value(value="${graphite.metrics.cpu:#{null}}")
    private String cpuGraphiteExpr;
    @Value(value="${graphite.metrics.memory:#{null}}")
    private String memoryGraphiteExpr;
    @Value(value="${graphite.metrics.network:#{null}}")
    private String networkGraphiteExpr;
    @Value(value="${graphite.resolution.seconds:0}")
    private int graphiteResolutionSeconds;
    @Value(value="${graphite.metrics-delay.seconds:0}")
    private int graphiteMetricsDelaySeconds;
    @Value(value="${benchmark.feature.graphite.metrics.collection.enabled:#{false}}")
    private boolean graphiteMetricsCollectionEnabled;

    public Optional<String> getCpuGraphiteExpr() {
        return Optional.ofNullable(this.cpuGraphiteExpr);
    }

    public Optional<String> getMemoryGraphiteExpr() {
        return Optional.ofNullable(this.memoryGraphiteExpr);
    }

    public Optional<String> getNetworkGraphiteExpr() {
        return Optional.ofNullable(this.networkGraphiteExpr);
    }

    public int getGraphiteResolutionSeconds() {
        return this.graphiteResolutionSeconds;
    }

    public Duration getGraphiteMetricsDelay() {
        return Duration.of(this.graphiteMetricsDelaySeconds, ChronoUnit.SECONDS);
    }

    public boolean isGraphiteMetricsCollectionEnabled() {
        return this.graphiteMetricsCollectionEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuGraphiteExpr", (Object)this.cpuGraphiteExpr).add("memoryGraphiteExpr", (Object)this.memoryGraphiteExpr).add("networkGraphiteExpr", (Object)this.networkGraphiteExpr).add("graphiteResolutionSeconds", this.graphiteResolutionSeconds).add("graphiteMetricsDelaySeconds", this.graphiteMetricsDelaySeconds).add("graphiteMetricsCollectionEnabled", this.graphiteMetricsCollectionEnabled).toString();
    }
}

