/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.jdbc;

import io.trino.benchto.driver.jdbc.MultipleDataSourcesProperties;
import io.trino.benchto.driver.utils.PropertiesUtils;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
public class MultipleDataSourcesConfiguration
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private MultipleDataSourcesProperties multipleDataSourcesProperties;

    public void setEnvironment(Environment environment) {
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)ConfigurableEnvironment.class.cast(environment);
        this.multipleDataSourcesProperties = PropertiesUtils.resolveEnvironmentProperties(configurableEnvironment, MultipleDataSourcesProperties.class);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map<String, DataSource> dataSources = this.createDeclaredDataSources();
        this.register(beanFactory, dataSources);
    }

    private Map<String, DataSource> createDeclaredDataSources() {
        return this.multipleDataSourcesProperties.getDataSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createDataSource((DataSourceProperties)entry.getValue())));
    }

    private DataSource createDataSource(DataSourceProperties properties) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(properties.determineDriverClassName());
        dataSource.setUrl(properties.determineUrl());
        dataSource.setUsername(properties.determineUsername());
        dataSource.setPassword(properties.determinePassword());
        return dataSource;
    }

    private void register(ConfigurableListableBeanFactory beanFactory, Map<String, DataSource> dataSources) {
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            beanFactory.registerSingleton(entry.getKey(), (Object)entry.getValue());
        }
    }
}

