/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners.profiler.perf;

import io.trino.benchto.driver.listeners.profiler.QueryProfiler;
import io.trino.benchto.driver.listeners.profiler.perf.PerfProfilerProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.profiler.perf", value={"enabled"}, havingValue="true")
public class PerfProfiler
implements QueryProfiler {
    private static final Logger LOG = LoggerFactory.getLogger(PerfProfiler.class);
    @Autowired
    PerfProfilerProperties profilerProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    @Retryable(value={IOException.class}, backoff=@Backoff(value=200L), maxAttempts=2)
    public void start(String workerName, String benchmarkName, String queryName, int sequenceId) {
        this.runPerf(workerName, this.profilerProperties.getShell2httpPort(), benchmarkName, queryName, sequenceId);
    }

    @Override
    @Retryable(value={IOException.class}, backoff=@Backoff(value=200L), maxAttempts=2)
    public void stop(String workerName, String benchmarkName, String queryName, int sequenceId) {
        LOG.info("Sending SIGTERM at %s side to perf".formatted(workerName));
        this.stopPerf(workerName, this.profilerProperties.getShell2httpPort());
    }

    private void runPerf(String nodeName, int port, String benchmarkName, String queryName, int sequenceId) {
        String stdoutFile = Path.of(this.profilerProperties.getOutputPath().toString(), benchmarkName, "%s_%d_perf_stdout.txt".formatted(queryName, sequenceId)).toString();
        URI uri = UriComponentsBuilder.fromUriString((String)"http://%s".formatted(nodeName)).port(port).queryParam("stdout", new Object[]{URLEncoder.encode(stdoutFile, StandardCharsets.UTF_8)}).path("/start-perf").build().toUri();
        this.restTemplate.getForObject(uri, Object.class);
    }

    private void stopPerf(String nodeName, int port) {
        URI uri = UriComponentsBuilder.fromUriString((String)"http://%s".formatted(nodeName)).port(port).path("/stop-perf").build().toUri();
        this.restTemplate.getForObject(uri, Object.class);
    }

    public String toString() {
        return "perf";
    }
}

