/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.presto;

import com.google.common.base.Preconditions;
import io.trino.benchto.driver.BenchmarkProperties;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="presto", value={"url"})
public class PrestoClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrestoClient.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BenchmarkProperties properties;

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public String getQueryInfo(String queryId) {
        URI uri = this.buildQueryInfoURI(queryId);
        HttpHeaders headers = new HttpHeaders();
        this.properties.getPrestoUsername().ifPresent(username -> headers.set("X-Trino-User", username));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
        return (String)response.getBody();
    }

    private URI buildQueryInfoURI(String queryId) {
        Preconditions.checkState((!this.properties.getPrestoURL().isEmpty() ? 1 : 0) != 0);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.properties.getPrestoURL()).pathSegment(new String[]{"v1", "query", queryId});
        return URI.create(uriBuilder.toUriString());
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public Optional<String> getQueryCompletionEvent(String queryId) {
        Optional<URI> uri = this.buildQueryCompletionEventURI(queryId);
        if (uri.isEmpty()) {
            return Optional.empty();
        }
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uri.get(), HttpMethod.GET, entity, String.class);
            return Optional.of((String)response.getBody());
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                LOGGER.warn("Query completion event for " + queryId + " not found");
                return Optional.empty();
            }
            LOGGER.error("Unexpected error " + String.valueOf(e.getStatusCode()) + " when gettin query completion event for " + queryId, (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<URI> buildQueryCompletionEventURI(String queryId) {
        return this.properties.getPrestoHttpEventListenerURL().map(baseUrl -> {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)baseUrl).pathSegment(new String[]{"v1", "events", "completedQueries", "get", queryId});
            return URI.create(uriBuilder.toUriString());
        });
    }
}

