/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.presto;

import io.trino.benchto.driver.Measurable;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import io.trino.benchto.driver.service.Measurement;
import io.trino.jdbc.QueryStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.presto", value={"metrics.collection.enabled"})
public class PrestoMetricsLoader
implements PostExecutionMeasurementProvider {
    @Override
    public CompletableFuture<List<Measurement>> loadMeasurements(Measurable measurable) {
        QueryExecutionResult executionResult;
        if (measurable instanceof QueryExecutionResult && (executionResult = (QueryExecutionResult)measurable).getPrestoQueryStats().isPresent() && !executionResult.getBenchmark().isThroughputTest()) {
            return CompletableFuture.completedFuture(this.loadMetrics(executionResult.getPrestoQueryStats().get()));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private List<Measurement> loadMetrics(QueryStats queryStats) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        measurements.add(Measurement.measurement("planningTime", "MILLISECONDS", queryStats.getPlanningTimeMillis()));
        measurements.add(Measurement.measurement("analysisTime", "MILLISECONDS", queryStats.getAnalysisTimeMillis()));
        measurements.add(Measurement.measurement("totalCpuTime", "MILLISECONDS", queryStats.getCpuTimeMillis()));
        measurements.add(Measurement.measurement("totalScheduledTime", "MILLISECONDS", queryStats.getWallTimeMillis()));
        measurements.add(Measurement.measurement("queuedTime", "MILLISECONDS", queryStats.getQueuedTimeMillis()));
        measurements.add(Measurement.measurement("elapsedTime", "MILLISECONDS", queryStats.getElapsedTimeMillis()));
        measurements.add(Measurement.measurement("finishingTime", "MILLISECONDS", queryStats.getFinishingTimeMillis()));
        measurements.add(Measurement.measurement("physicalInputReadTime", "MILLISECONDS", queryStats.getPhysicalInputTimeMillis()));
        measurements.add(Measurement.measurement("rawInputDataSize", "BYTES", queryStats.getProcessedBytes()));
        measurements.add(Measurement.measurement("physicalInputDataSize", "BYTES", queryStats.getPhysicalInputBytes()));
        measurements.add(Measurement.measurement("physicalWrittenDataSize", "BYTES", queryStats.getPhysicalWrittenBytes()));
        measurements.add(Measurement.measurement("internalNetworkInputDataSize", "BYTES", queryStats.getInternalNetworkInputBytes()));
        measurements.add(Measurement.measurement("peakTotalMemoryReservation", "BYTES", queryStats.getPeakMemoryBytes()));
        return measurements;
    }
}

