/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.trino.benchto.driver.BenchmarkProperties;
import io.trino.benchto.driver.service.Measurement;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class BenchmarkServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkServiceClient.class);
    @Autowired
    private BenchmarkProperties properties;
    @Autowired
    private RestTemplate restTemplate;

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public Instant getServiceCurrentTime() {
        Long serviceCurrentTime = this.postForObject("/v1/time/current-time-millis", null, Long.class);
        return Instant.ofEpochMilli(Objects.requireNonNull(serviceCurrentTime, "service returned null time"));
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public List<String> generateUniqueBenchmarkNames(List<GenerateUniqueNamesRequestItem> generateUniqueNamesRequestItems) {
        Object[] uniqueNames = this.postForObject("/v1/benchmark/generate-unique-names", generateUniqueNamesRequestItems, String[].class);
        return ImmutableList.copyOf((Object[])uniqueNames);
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public List<Duration> getBenchmarkSuccessfulExecutionAges(List<String> benchmarkUniqueNames) {
        Object[] ages = this.postForObject("/v1/benchmark/get-successful-execution-ages", benchmarkUniqueNames, Duration[].class);
        return ImmutableList.copyOf((Object[])ages);
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public String startBenchmark(String uniqueBenchmarkName, String benchmarkSequenceId, BenchmarkStartRequest request) {
        Map<String, String> requestParams = this.requestParams(uniqueBenchmarkName, benchmarkSequenceId);
        return this.postForObject("/v1/benchmark/{uniqueBenchmarkName}/{benchmarkSequenceId}/start", (Object)request, requestParams);
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public void finishBenchmark(String uniqueBenchmarkName, String benchmarkSequenceId, FinishRequest request) {
        Map<String, String> requestParams = this.requestParams(uniqueBenchmarkName, benchmarkSequenceId);
        this.postForObject("/v1/benchmark/{uniqueBenchmarkName}/{benchmarkSequenceId}/finish", (Object)request, requestParams);
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public void startExecution(String uniqueBenchmarkName, String benchmarkSequenceId, String executionSequenceId, ExecutionStartRequest request) {
        Map<String, String> requestParams = this.requestParams(uniqueBenchmarkName, benchmarkSequenceId);
        requestParams.put("executionSequenceId", executionSequenceId);
        this.postForObject("/v1/benchmark/{uniqueBenchmarkName}/{benchmarkSequenceId}/execution/{executionSequenceId}/start", (Object)request, requestParams);
    }

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public void finishExecution(String uniqueBenchmarkName, String benchmarkSequenceId, String executionSequenceId, FinishRequest request) {
        Map<String, String> requestParams = this.requestParams(uniqueBenchmarkName, benchmarkSequenceId);
        requestParams.put("executionSequenceId", executionSequenceId);
        this.postForObject("/v1/benchmark/{uniqueBenchmarkName}/{benchmarkSequenceId}/execution/{executionSequenceId}/finish", (Object)request, requestParams);
    }

    private Map<String, String> requestParams(String uniqueBenchmarkName, String benchmarkSequenceId) {
        HashMap params = Maps.newHashMap();
        params.put("serviceUrl", this.properties.getServiceURL());
        params.put("uniqueBenchmarkName", uniqueBenchmarkName);
        params.put("benchmarkSequenceId", benchmarkSequenceId);
        return params;
    }

    private String postForObject(String url, Object request, Map<String, String> requestParams) {
        return this.postForObject(url, request, String.class, requestParams);
    }

    private <T> T postForObject(String url, Object request, Class<T> clazz) {
        return this.postForObject(url, request, clazz, (Map<String, String>)ImmutableMap.of());
    }

    private <T> T postForObject(String url, Object request, Class<T> clazz, Map<String, String> requestParams) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.properties.getServiceURL()).path(url);
        URI uri = uriBuilder.buildAndExpand(requestParams).toUri();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Post object to benchmark service on URL: {}, with request: {}", (Object)uri, request);
        }
        return (T)this.restTemplate.postForObject(uri, request, clazz);
    }

    public static class FinishRequest
    extends AttributeRequest {
        private Status status;
        private Instant endTime;
        private final List<Measurement> measurements = Lists.newArrayList();
        private String queryInfo;
        private String queryCompletionEvent;

        private FinishRequest() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("measurements", this.measurements).add("status", (Object)this.status).add("endTime", (Object)this.endTime).add("attributes", (Object)this.attributes).toString();
        }

        public static enum Status {
            STARTED,
            ENDED,
            FAILED;

        }

        public static class FinishRequestBuilder
        extends AttributeRequest.AttributeRequestBuilder<FinishRequest> {
            public FinishRequestBuilder() {
                super(new FinishRequest());
            }

            public FinishRequestBuilder withStatus(Status status) {
                ((FinishRequest)this.request).status = status;
                return this;
            }

            public FinishRequestBuilder withEndTime(Instant endTime) {
                ((FinishRequest)this.request).endTime = endTime;
                return this;
            }

            public FinishRequestBuilder addMeasurement(Measurement measurement) {
                ((FinishRequest)this.request).measurements.add(measurement);
                return this;
            }

            public FinishRequestBuilder addMeasurements(Collection<Measurement> measurements) {
                ((FinishRequest)this.request).measurements.addAll(measurements);
                return this;
            }

            public FinishRequestBuilder addQueryInfo(String queryInfo) {
                ((FinishRequest)this.request).queryInfo = queryInfo;
                return this;
            }

            public FinishRequestBuilder addQueryCompletionEvent(String queryCompletionEvent) {
                ((FinishRequest)this.request).queryCompletionEvent = queryCompletionEvent;
                return this;
            }
        }
    }

    public static class ExecutionStartRequest
    extends AttributeRequest {
        private ExecutionStartRequest() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("attributes", (Object)this.attributes).toString();
        }

        public static class ExecutionStartRequestBuilder
        extends AttributeRequest.AttributeRequestBuilder<ExecutionStartRequest> {
            public ExecutionStartRequestBuilder() {
                super(new ExecutionStartRequest());
            }
        }
    }

    public static class BenchmarkStartRequest
    extends AttributeRequest {
        private String name;
        private String environmentName;
        private final Map<String, String> variables = Maps.newHashMap();

        private BenchmarkStartRequest() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("environmentName", (Object)this.environmentName).add("variables", this.variables).add("attributes", (Object)this.attributes).toString();
        }

        public static class BenchmarkStartRequestBuilder
        extends AttributeRequest.AttributeRequestBuilder<BenchmarkStartRequest> {
            public BenchmarkStartRequestBuilder(String name) {
                super(new BenchmarkStartRequest());
                ((BenchmarkStartRequest)this.request).name = name;
            }

            public BenchmarkStartRequestBuilder environmentName(String environmentName) {
                ((BenchmarkStartRequest)this.request).environmentName = environmentName;
                return this;
            }

            public BenchmarkStartRequestBuilder addVariable(String name, String value) {
                ((BenchmarkStartRequest)this.request).variables.put(name, value);
                return this;
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static abstract class AttributeRequest {
        protected Map<String, String> attributes = Maps.newHashMap();

        public static abstract class AttributeRequestBuilder<T extends AttributeRequest> {
            protected final T request;

            public AttributeRequestBuilder(T request) {
                this.request = request;
            }

            public AttributeRequestBuilder<T> addAttribute(String name, String value) {
                ((AttributeRequest)this.request).attributes.put(name, value);
                return this;
            }

            public T build() {
                return this.request;
            }
        }
    }

    public static class GenerateUniqueNamesRequestItem {
        private final String name;
        private final Map<String, String> variables;

        private GenerateUniqueNamesRequestItem(String name, Map<String, String> variables) {
            this.name = name;
            this.variables = variables;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public static GenerateUniqueNamesRequestItem generateUniqueNamesRequestItem(String name, Map<String, String> variables) {
            return new GenerateUniqueNamesRequestItem(name, variables);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("variables", this.variables).toString();
        }
    }
}

