/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.utils;

import io.trino.benchto.driver.execution.ResultComparisonException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryUtils.class);
    private static final int LOGGED_ROWS = 10;

    public static int fetchRows(String sqlStatement, ResultSet resultSet) throws SQLException {
        LOGGER.info("First {} rows for query: {}", (Object)10, (Object)sqlStatement);
        int rowsCount = 0;
        while (resultSet.next()) {
            if (rowsCount < 10) {
                QueryUtils.logRow(rowsCount + 1, resultSet);
            } else if (rowsCount == 10) {
                LOGGER.info("There are more unlogged rows");
            }
            ++rowsCount;
        }
        return rowsCount;
    }

    public static int compareRows(Path resultFile, ResultSet resultSet) throws SQLException {
        int n;
        block11: {
            LOGGER.info("Comparing result with {}", (Object)resultFile);
            BufferedReader reader = Files.newBufferedReader(resultFile);
            try {
                int lineCount;
                block10: {
                    String resultRow;
                    String dbRow;
                    lineCount = 0;
                    do {
                        ++lineCount;
                        resultRow = reader.readLine();
                        boolean hasRows = resultSet.next();
                        if (resultRow == null && !hasRows) break block10;
                        if (resultRow == null) {
                            throw new ResultComparisonException(String.format("Result file has %d lines, actual result has more rows", lineCount - 1));
                        }
                        if (hasRows) continue;
                        throw new ResultComparisonException(String.format("Actual result has %d rows, result file has more lines", lineCount - 1));
                    } while ((dbRow = QueryUtils.resultRowToString(resultSet)).equals(resultRow));
                    throw new ResultComparisonException(String.format("Incorrect result at row %d, expected %s, got %s", lineCount, resultRow, dbRow));
                }
                n = lineCount;
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ResultComparisonException("Error opening result file", e);
                }
            }
            reader.close();
        }
        return n;
    }

    public static void compareCount(Path resultFile, int rowCount) {
        LOGGER.info("Comparing result count with {}", (Object)resultFile);
        try (BufferedReader reader = Files.newBufferedReader(resultFile);){
            String expectedCount = reader.readLine();
            if (expectedCount == null) {
                throw new ResultComparisonException("Result file should have exactly one row with expected count.");
            }
            if (reader.readLine() != null) {
                throw new ResultComparisonException("Result file should not have more then one row.");
            }
            if (!String.valueOf(rowCount).equals(expectedCount)) {
                throw new ResultComparisonException(String.format("Incorrect row count, expected %s, got %d", expectedCount, rowCount));
            }
        }
        catch (IOException e) {
            throw new ResultComparisonException("Error opening result file", e);
        }
    }

    public static boolean isSelectQuery(String sql) {
        return (sql = sql.trim().toLowerCase()).startsWith("select") || sql.startsWith("show") || sql.startsWith("with");
    }

    private static String resultRowToString(ResultSet resultSet) throws SQLException {
        return IntStream.range(1, resultSet.getMetaData().getColumnCount() + 1).boxed().map(i -> {
            try {
                Object value = resultSet.getObject((int)i);
                if (value == null) {
                    return "";
                }
                if (value instanceof byte[]) {
                    return Arrays.toString((byte[])value);
                }
                return value.toString();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining(","));
    }

    private static void logRow(int rowNumber, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        StringJoiner joiner = new StringJoiner("; ", "[", "]");
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            joiner.add(resultSetMetaData.getColumnName(i) + ": " + String.valueOf(resultSet.getObject(i)));
        }
        LOGGER.info("Row: " + rowNumber + ", column values: " + String.valueOf(joiner));
    }

    private QueryUtils() {
    }
}

