package io.trino.hadoop.$internal.com.ctc.wstx.osgi;

import java.util.Properties;

import io.trino.hadoop.$internal.org.codehaus.stax2.XMLOutputFactory2;
import io.trino.hadoop.$internal.org.codehaus.stax2.osgi.Stax2OutputFactoryProvider;

import io.trino.hadoop.$internal.com.ctc.wstx.api.ReaderConfig;
import io.trino.hadoop.$internal.com.ctc.wstx.stax.WstxOutputFactory;

public class OutputFactoryProviderImpl
    implements Stax2OutputFactoryProvider
{
    @Override
    public XMLOutputFactory2 createOutputFactory() {
        return new WstxOutputFactory();
    }

    protected Properties getProperties()
    {
        Properties props = new Properties();
        props.setProperty(OSGI_SVC_PROP_IMPL_NAME, ReaderConfig.getImplName());
        props.setProperty(OSGI_SVC_PROP_IMPL_VERSION, ReaderConfig.getImplVersion());
        return props;
    }
}
