/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.hadoop.$internal.org.apache.avro.reflect;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Expert: Fields with this annotation are encoded using the given custom encoder.
 * This annotation overrides {@link io.trino.hadoop.$internal.org.apache.avro.reflect.Stringable Stringable} and {@link io.trino.hadoop.$internal.org.apache.avro.reflect.Nullable Nullable}.
 * Since no validation is performed, invalid custom encodings may result in an unreadable file.
 * Use of {@link io.trino.hadoop.$internal.org.apache.avro.io.ValidatingEncoder} is recommended.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface AvroEncode {
  Class<? extends CustomEncoding<?>> using();
}
