/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.keytab;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface KrbKeytab {

    List<PrincipalName> getPrincipals();

    void addKeytabEntries(List<KeytabEntry> entries);

    void removeKeytabEntries(PrincipalName principal);

    void removeKeytabEntries(PrincipalName principal, int kvno);

    void removeKeytabEntry(KeytabEntry entry);

    List<KeytabEntry> getKeytabEntries(PrincipalName principal);

    EncryptionKey getKey(PrincipalName principal, EncryptionType keyType);

    void load(File keytabFile) throws IOException;

    void load(InputStream inputStream) throws IOException;

    void addEntry(KeytabEntry entry);

    void store(File keytabFile) throws IOException;

    void store(OutputStream outputStream) throws IOException;
}
